/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.SmtpReloadable;
import com.openexchange.smtp.osgi.MailcapServiceTracker;
import com.openexchange.smtp.services.Services;
import com.openexchange.threadpool.ThreadPoolService;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.activation.MailcapCommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMTPActivator
extends HousekeepingActivator {
    private static final Logger LOG = LoggerFactory.getLogger(SMTPActivator.class);

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class, MailAccountStorageService.class, ConfigViewFactory.class, ThreadPoolService.class};
    }

    public void startBundle() throws Exception {
        try {
            Services.setServiceLookup((ServiceLookup)this);
            this.trackService(HostnameService.class);
            this.track(MailcapCommandMap.class, new MailcapServiceTracker(this.context));
            this.openTrackers();
            Hashtable<String, String> dictionary = new Hashtable<String, String>(1);
            ((Dictionary)dictionary).put("protocol", SMTPProvider.PROTOCOL_SMTP.toString());
            this.registerService(TransportProvider.class, (Object)SMTPProvider.getInstance(), dictionary);
            this.registerService(Reloadable.class, SmtpReloadable.getInstance());
        }
        catch (Throwable t) {
            LOG.error("", t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    public void stopBundle() throws Exception {
        try {
            this.cleanUp();
            Services.setServiceLookup(null);
        }
        catch (Throwable t) {
            LOG.error("", t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }
}

