/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.exception.OXException;
import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.I18nTranslator;
import com.openexchange.i18n.Translator;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.json.I18n;
import com.openexchange.publish.json.MultipleHandlerTools;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.publish.json.PublicationTargetWriter;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class PublicationTargetMultipleHandler
implements MultipleHandler {
    static final Set<String> ACTIONS_REQUIRING_BODY = Collections.emptySet();
    private PublicationTargetDiscoveryService discoverer = null;

    public PublicationTargetMultipleHandler(PublicationTargetDiscoveryService discoverer) {
        this.discoverer = discoverer;
    }

    public void close() {
    }

    public Date getTimestamp() {
        return null;
    }

    public JSONValue performRequest(String action, JSONObject request, ServerSession session, boolean secure) throws JSONException, OXException {
        try {
            if (null == action) {
                throw PublicationJSONErrorMessage.MISSING_PARAMETER.create("action");
            }
            if (action.equals("listTargets") || action.equals("all")) {
                return this.listTargets(request, session);
            }
            if (action.equals("getTarget") || action.equals("get")) {
                return this.getTarget(request, session);
            }
            throw PublicationJSONErrorMessage.UNKNOWN_ACTION.create(action);
        }
        catch (OXException x) {
            throw x;
        }
        catch (Throwable t) {
            throw MultipleHandlerTools.wrapThrowable(t);
        }
    }

    public Collection<OXException> getWarnings() {
        return Collections.emptySet();
    }

    private JSONValue getTarget(JSONObject request, ServerSession session) throws OXException, OXException, JSONException {
        String identifier = request.optString("id");
        if (identifier == null) {
            throw PublicationJSONErrorMessage.MISSING_PARAMETER.create("id");
        }
        PublicationTarget target = this.discoverer.getTarget(identifier);
        if (target == null) {
            throw PublicationJSONErrorMessage.UNKNOWN_TARGET.create(identifier);
        }
        JSONObject data = new PublicationTargetWriter(this.createTranslator(session)).write(target, session.getUser(), session.getUserPermissionBits());
        return data;
    }

    private Translator createTranslator(ServerSession session) {
        Locale locale = session.getUser().getLocale();
        I18nService service = I18n.getInstance().get(locale);
        return null == service ? Translator.EMPTY : new I18nTranslator(service);
    }

    private JSONValue listTargets(JSONObject request, ServerSession session) throws JSONException, OXException, OXException {
        Collection targets = this.discoverer.listTargets();
        String[] columns = this.getColumns(request);
        JSONArray json = new PublicationTargetWriter(this.createTranslator(session)).writeJSONArray(targets, columns, session.getUser(), session.getUserPermissionBits());
        return json;
    }

    private String[] getColumns(JSONObject req) {
        String columns = req.optString("columns");
        if (columns == null) {
            return new String[]{"id", "displayName", "module", "icon", "formDescription"};
        }
        return columns.split("\\s*,\\s*");
    }
}

