/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationErrorMessage;
import com.openexchange.publish.PublicationService;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.json.EntityType;
import com.openexchange.publish.json.Hostname;
import com.openexchange.publish.json.MultipleHandlerTools;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.publish.json.PublicationParser;
import com.openexchange.publish.json.PublicationWriter;
import com.openexchange.tools.QueryStringPositionComparator;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationMultipleHandler
implements MultipleHandler {
    private static final String PROPERTY_USE_OTHER_DOMAIN = "com.openexchange.publish.domain";
    private static final String PROPERTY_USE_OTHER_SUBDOMAIN = "com.openexchange.publish.subdomain";
    private final PublicationTargetDiscoveryService discovery;
    private final Map<String, EntityType> entities;
    private final ConfigurationService config;
    public static final Set<String> ACTIONS_REQUIRING_BODY = new HashSet<String>(){
        private static final long serialVersionUID = -4485493200664773739L;
        {
            this.add("new");
            this.add("update");
            this.add("delete");
            this.add("list");
        }
    };
    private static final Set<String> KNOWN_PARAMS = new HashSet<String>(){
        private static final long serialVersionUID = -6947818649378328911L;
        {
            this.add("entityModule");
            this.add("columns");
            this.add("session");
            this.add("action");
        }
    };

    public PublicationMultipleHandler(PublicationTargetDiscoveryService discovery, Map<String, EntityType> entities, ConfigurationService config) {
        this.discovery = discovery;
        this.entities = entities;
        this.config = config;
    }

    public void close() {
    }

    public Date getTimestamp() {
        return null;
    }

    public Object performRequest(String action, JSONObject request, ServerSession session, boolean secure) throws JSONException, OXException {
        try {
            if (null == action) {
                throw PublicationJSONErrorMessage.MISSING_PARAMETER.create("action");
            }
            if (action.equals("new")) {
                return this.createPublication(request, session);
            }
            if (action.equals("update")) {
                return this.updatePublication(request, session);
            }
            if (action.equals("delete")) {
                return this.deletePublication(request, session);
            }
            if (action.equals("get")) {
                return this.loadPublication(request, session);
            }
            if (action.equals("all")) {
                return this.loadAllPublications(request, session);
            }
            if (action.equals("list")) {
                return this.listPublications(request, session);
            }
            throw PublicationJSONErrorMessage.UNKNOWN_ACTION.create(action);
        }
        catch (JSONException x) {
            throw x;
        }
        catch (OXException x) {
            throw x;
        }
        catch (Throwable t) {
            throw MultipleHandlerTools.wrapThrowable(t);
        }
    }

    private Object listPublications(JSONObject request, ServerSession session) throws JSONException, OXException, OXException {
        JSONArray ids = request.getJSONArray("data");
        Context context = session.getContext();
        ArrayList<Publication> publications = new ArrayList<Publication>(ids.length());
        int size = ids.length();
        for (int i = 0; i < size; ++i) {
            PublicationService publicationService;
            Publication publication;
            int id = ids.getInt(i);
            PublicationTarget target = this.discovery.getTarget(context, id);
            if (target == null || (publication = (publicationService = target.getPublicationService()).load(context, id)) == null) continue;
            publications.add(publication);
        }
        String[] basicColumns = this.getBasicColumns(request);
        Map<String, String[]> dynamicColumns = this.getDynamicColumns(request);
        List<String> dynamicColumnOrder = this.getDynamicColumnOrder(request);
        TimeZone tz = null;
        String sTimeZone = request.optString("timezone");
        tz = sTimeZone != null ? TimeZone.getTimeZone(sTimeZone) : TimeZone.getTimeZone(session.getUser().getTimeZone());
        return this.createList(publications, basicColumns, dynamicColumns, dynamicColumnOrder, tz);
    }

    private Object loadAllPublications(JSONObject request, ServerSession session) throws OXException, JSONException, OXException {
        List<Publication> publications;
        Context context = session.getContext();
        int userId = session.getUserId();
        boolean containsFolderOrId = false;
        if (request.has("folder") || request.has("id")) {
            if (!request.has("entityModule")) {
                throw PublicationJSONErrorMessage.MISSING_PARAMETER.create("entityModule");
            }
            containsFolderOrId = true;
        }
        String module = null;
        if (request.has("entityModule")) {
            module = request.optString("entityModule");
        }
        if (containsFolderOrId) {
            EntityType entityType = this.entities.get(module);
            if (null == entityType) {
                throw PublicationJSONErrorMessage.UNKOWN_ENTITY_MODULE.create(module);
            }
            String entityId = entityType.toEntityID(request);
            publications = this.loadAllPublicationsForEntity(context, entityId, module);
        } else {
            publications = this.loadAllPublicationsForUser(context, userId, module);
        }
        String[] basicColumns = this.getBasicColumns(request);
        Map<String, String[]> dynamicColumns = this.getDynamicColumns(request);
        List<String> dynamicColumnOrder = this.getDynamicColumnOrder(request);
        TimeZone tz = null;
        String sTimeZone = request.optString("timezone");
        tz = sTimeZone != null ? TimeZone.getTimeZone(sTimeZone) : TimeZone.getTimeZone(session.getUser().getTimeZone());
        return this.createList(publications, basicColumns, dynamicColumns, dynamicColumnOrder, tz);
    }

    private Map<String, String[]> getDynamicColumns(JSONObject request) throws JSONException {
        List<String> identifiers = this.getDynamicColumnOrder(request);
        HashMap<String, String[]> dynamicColumns = new HashMap<String, String[]>();
        for (String identifier : identifiers) {
            String columns = request.optString(identifier);
            if (columns == null || columns.equals("")) continue;
            dynamicColumns.put(identifier, columns.split("\\s*,\\s*"));
        }
        return dynamicColumns;
    }

    private List<String> getDynamicColumnOrder(JSONObject request) throws JSONException {
        if (request.has("dynamicColumnPlugins")) {
            return Arrays.asList(request.getString("dynamicColumnPlugins").split("\\s*,\\s*"));
        }
        ArrayList<String> dynamicColumnIdentifiers = new ArrayList<String>();
        for (String paramName : request.keySet()) {
            if (KNOWN_PARAMS.contains(paramName) || paramName.indexOf(46) < 0) continue;
            dynamicColumnIdentifiers.add(paramName);
        }
        String order = request.optString("__query");
        Collections.sort(dynamicColumnIdentifiers, new QueryStringPositionComparator(order));
        return dynamicColumnIdentifiers;
    }

    private String[] getBasicColumns(JSONObject request) {
        String columns = request.optString("columns");
        if (columns == null || columns.equals("")) {
            return new String[]{"id", "entity", "entityModule", "target", "enabled"};
        }
        return columns.split("\\s*,\\s*");
    }

    private List<Publication> loadAllPublicationsForUser(Context context, int userId, String module) throws OXException {
        LinkedList<Publication> publications = new LinkedList<Publication>();
        Collection targets = this.discovery.listTargets();
        for (PublicationTarget target : targets) {
            PublicationService publicationService;
            Collection allPublicationsForUser = null;
            if (module == null) {
                publicationService = target.getPublicationService();
                allPublicationsForUser = publicationService.getAllPublications(context, userId, target.getModule());
            } else if (target.isResponsibleFor(module)) {
                publicationService = target.getPublicationService();
                allPublicationsForUser = publicationService.getAllPublications(context, userId, module);
            }
            if (allPublicationsForUser == null) continue;
            publications.addAll(allPublicationsForUser);
        }
        return publications;
    }

    private List<Publication> loadAllPublicationsForEntity(Context context, String entityId, String module) throws OXException {
        LinkedList<Publication> publications = new LinkedList<Publication>();
        Collection targetsForEntityType = this.discovery.getTargetsForEntityType(module);
        for (PublicationTarget target : targetsForEntityType) {
            PublicationService publicationService;
            Collection allPublicationsForEntity;
            if (!target.isResponsibleFor(module) || (allPublicationsForEntity = (publicationService = target.getPublicationService()).getAllPublications(context, entityId)) == null) continue;
            publications.addAll(allPublicationsForEntity);
        }
        return publications;
    }

    private Object loadPublication(JSONObject request, ServerSession session) throws JSONException, OXException {
        int id = request.getInt("id");
        String target = request.optString("target");
        Context context = session.getContext();
        Publication publication = this.loadPublication(id, context, target);
        if (null == publication) {
            throw PublicationErrorMessage.PUBLICATION_NOT_FOUND_EXCEPTION.create();
        }
        String sTimeZone = request.optString("timezone");
        TimeZone tz = null;
        tz = sTimeZone != null ? TimeZone.getTimeZone(sTimeZone) : TimeZone.getTimeZone(session.getUser().getTimeZone());
        return this.createResponse(publication, this.getURLPrefix(request, publication), tz);
    }

    private String getURLPrefix(JSONObject request, Publication publication) {
        String hostname = Hostname.getInstance().getHostname(publication);
        String serverURL = request.optString("__serverURL");
        String protocol = "https://";
        if (hostname != null) {
            protocol = serverURL == null || serverURL.startsWith("https") ? "https://" : "http://";
            serverURL = protocol + hostname;
        } else if (serverURL != null) {
            hostname = serverURL.substring(serverURL.indexOf("://") + 3);
            protocol = serverURL.startsWith("https") ? "https://" : "http://";
        }
        String otherDomain = this.config.getProperty(PROPERTY_USE_OTHER_DOMAIN);
        String separateSubdomain = this.config.getProperty(PROPERTY_USE_OTHER_SUBDOMAIN);
        if (otherDomain != null) {
            return protocol + otherDomain;
        }
        if (separateSubdomain != null) {
            return protocol + separateSubdomain + '.' + hostname;
        }
        return serverURL;
    }

    private Publication loadPublication(int id, Context context, String target) throws OXException {
        PublicationService service = null;
        if (target != null && !target.equals("")) {
            PublicationTarget t = this.discovery.getTarget(target);
            if (t == null) {
                return null;
            }
            service = t.getPublicationService();
        } else {
            PublicationTarget t = this.discovery.getTarget(context, id);
            if (t == null) {
                return null;
            }
            service = t.getPublicationService();
        }
        if (service == null) {
            return null;
        }
        return service.load(context, id);
    }

    private Object deletePublication(JSONObject request, ServerSession session) throws OXException, JSONException {
        JSONArray ids = request.getJSONArray("data");
        Context context = session.getContext();
        int size = ids.length();
        for (int i = 0; i < size; ++i) {
            int id = ids.getInt(i);
            PublicationTarget target = this.discovery.getTarget(context, id);
            if (target == null) {
                throw PublicationErrorMessage.PUBLICATION_NOT_FOUND_EXCEPTION.create();
            }
            PublicationService publisher = target.getPublicationService();
            Publication publication = new Publication();
            publication.setContext(context);
            publication.setId(id);
            publication.setUserId(session.getUserId());
            publisher.delete(publication);
        }
        return Autoboxing.L((long)1L);
    }

    private Object updatePublication(JSONObject request, ServerSession session) throws JSONException, OXException, OXException {
        Publication publication = this.getPublication(request, session);
        publication.update();
        return Autoboxing.L((long)1L);
    }

    private Object createPublication(JSONObject request, ServerSession session) throws OXException, OXException, JSONException {
        Publication publication = this.getPublication(request, session);
        publication.setId(-1);
        publication.create();
        return Autoboxing.L((long)publication.getId());
    }

    private Object createList(List<Publication> publications, String[] basicColumns, Map<String, String[]> dynamicColumns, List<String> dynamicColumnOrder, TimeZone tz) throws OXException, JSONException {
        JSONArray rows = new JSONArray();
        PublicationWriter writer = new PublicationWriter();
        for (Publication publication : publications) {
            JSONArray row = writer.writeArray(publication, basicColumns, dynamicColumns, dynamicColumnOrder, publication.getTarget().getFormDescription(), tz);
            rows.put((Object)row);
        }
        return rows;
    }

    private Object createResponse(Publication publication, String urlPrefix, TimeZone tz) throws JSONException, OXException {
        JSONObject asJson = new PublicationWriter().write(publication, urlPrefix, tz);
        return asJson;
    }

    private Publication getPublication(JSONObject request, ServerSession session) throws JSONException, OXException, OXException {
        JSONObject object = request.getJSONObject("data");
        Publication publication = new PublicationParser(this.discovery).parse(object);
        publication.setUserId(session.getUserId());
        publication.setContext(session.getContext());
        if (publication.getTarget() == null && publication.getId() > 0) {
            PublicationTarget target = this.discovery.getTarget(publication.getContext(), publication.getId());
            publication.setTarget(target);
        }
        return publication;
    }

    public Collection<OXException> getWarnings() {
        return Collections.emptySet();
    }
}

