/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.java.SortableConcurrentList;
import com.openexchange.osgi.ServiceListing;
import com.openexchange.osgi.util.RankedService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class RankingAwareNearRegistryServiceTracker<S>
extends ServiceTracker<S, S>
implements ServiceListing<S> {
    private final SortableConcurrentList<RankedService<S>> services = new SortableConcurrentList();
    private final int defaultRanking;

    public RankingAwareNearRegistryServiceTracker(BundleContext context, Class<S> clazz) {
        this(context, clazz, 0);
    }

    public RankingAwareNearRegistryServiceTracker(BundleContext context, Class<S> clazz, int defaultRanking) {
        super(context, clazz, null);
        this.defaultRanking = defaultRanking;
    }

    @Override
    public List<S> getServiceList() {
        ArrayList ret = new ArrayList(this.services.size());
        for (RankedService rs : this.services) {
            ret.add(rs.service);
        }
        return ret;
    }

    public S addingService(ServiceReference<S> reference) {
        int ranking;
        Object service = this.context.getService(reference);
        RankedService<Object> rankedService = new RankedService<Object>(service, ranking = RankedService.getRanking(reference, this.defaultRanking));
        if (this.services.add(rankedService)) {
            this.services.sort();
            return (S)service;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void removedService(ServiceReference<S> reference, S service) {
        this.services.remove(new RankedService<S>(service, RankedService.getRanking(reference)));
        this.services.sort();
        this.context.ungetService(reference);
    }
}

