/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.google.common.collect.HashMultimap;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.SimpleRegistryListener;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class HousekeepingActivator
extends DeferredActivator {
    private final List<ServiceTracker<?, ?>> serviceTrackers = new LinkedList();
    private final HashMultimap<Object, ServiceRegistration<?>> serviceRegistrations = HashMultimap.create((int)6, (int)2);

    protected HousekeepingActivator() {
    }

    @Override
    protected void handleAvailability(Class<?> clazz) {
    }

    @Override
    protected void handleUnavailability(Class<?> clazz) {
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!this.serviceTrackers.isEmpty()) {
            this.openTrackers();
        }
    }

    @Override
    protected void stopBundle() throws Exception {
        this.cleanUp();
    }

    protected boolean hasRegisteredServices() {
        return !this.serviceRegistrations.isEmpty();
    }

    protected <S> void registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        LOG.debug("Registering service {} with class {}", service, clazz);
        this.serviceRegistrations.put(service, (Object)this.context.registerService(clazz, service, properties));
    }

    protected <S> void registerService(Class<S> clazz, S service) {
        this.registerService(clazz, service, null);
    }

    protected <S> void registerService(String className, Object service, Dictionary<String, ?> properties) {
        this.serviceRegistrations.put(service, (Object)this.context.registerService(className, service, properties));
    }

    protected <S> void registerService(String className, Object service) {
        this.registerService(className, service, null);
    }

    protected void rememberTracker(ServiceTracker<?, ?> tracker) {
        this.serviceTrackers.add(tracker);
    }

    protected void forgetTracker(ServiceTracker<?, ?> tracker) {
        this.serviceTrackers.remove(tracker);
    }

    protected Class<?>[] getOptionalServices() {
        return EMPTY_CLASSES;
    }

    protected <S> ServiceTracker<S, S> trackService(Class<S> clazz) {
        ServiceTracker tracker = new ServiceTracker(this.context, clazz, new ServiceLookupTrackerCustomizer<S>(clazz, this, this.context));
        this.rememberTracker(tracker);
        return tracker;
    }

    protected <S> ServiceTracker<S, S> track(Class<S> clazz, ServiceTrackerCustomizer<S, S> customizer) {
        ServiceTracker tracker = new ServiceTracker(this.context, clazz, customizer);
        this.rememberTracker(tracker);
        return tracker;
    }

    protected <S> ServiceTracker<S, S> track(Filter filter, ServiceTrackerCustomizer<S, S> customizer) {
        ServiceTracker tracker = new ServiceTracker(this.context, filter, customizer);
        this.rememberTracker(tracker);
        return tracker;
    }

    protected <S> ServiceTracker<S, S> track(Class<S> clazz) {
        if (clazz.isAssignableFrom(ServiceTrackerCustomizer.class)) {
            LOG.warn("ServiceTracker/ServiceTrackerCustomizer \"{}\" is tracked as a service! You probably wanted to call rememberTracker() and open it afterwards.", (Object)clazz.getName());
        }
        return this.track(clazz, (ServiceTrackerCustomizer)null);
    }

    protected <S> ServiceTracker<S, S> track(Filter filter) {
        return this.track(filter, (ServiceTrackerCustomizer)null);
    }

    protected <S> ServiceTracker<S, S> track(Class<S> clazz, SimpleRegistryListener<S> listener) {
        return this.track(clazz, new SimpleRegistryListenerTrackerCustomizer<S>(listener, this.context));
    }

    protected <S> ServiceTracker<S, S> track(Filter filter, SimpleRegistryListener<S> listener) {
        return this.track(filter, new SimpleRegistryListenerTrackerCustomizer<S>(listener, this.context));
    }

    protected void openTrackers() {
        Class<?>[] optionalServices = this.getOptionalServices();
        if (null != optionalServices) {
            for (Class<?> clazz : optionalServices) {
                this.trackService(clazz);
            }
        }
        for (ServiceTracker serviceTracker : new LinkedList(this.serviceTrackers)) {
            serviceTracker.open();
        }
    }

    protected void closeTrackers() {
        for (ServiceTracker serviceTracker : new LinkedList(this.serviceTrackers)) {
            serviceTracker.close();
        }
    }

    protected void clearTrackers() {
        this.serviceTrackers.clear();
    }

    protected void unregisterServices() {
        for (ServiceRegistration registration : this.serviceRegistrations.values()) {
            LOG.debug("Unregistering {}", (Object)registration);
            registration.unregister();
        }
        this.serviceRegistrations.clear();
    }

    protected <S> void unregisterService(S service) {
        for (ServiceRegistration registration : this.serviceRegistrations.removeAll(service)) {
            LOG.debug("Unregistering {}", (Object)registration);
            registration.unregister();
        }
    }

    protected void cleanUp() {
        this.closeTrackers();
        this.clearTrackers();
        this.unregisterServices();
    }

    private static final class SimpleRegistryListenerTrackerCustomizer<S>
    implements ServiceTrackerCustomizer<S, S> {
        private final SimpleRegistryListener<S> listener;
        private final BundleContext context;

        protected SimpleRegistryListenerTrackerCustomizer(SimpleRegistryListener<S> listener, BundleContext context) {
            this.listener = listener;
            this.context = context;
        }

        public S addingService(ServiceReference<S> serviceReference) {
            Object service = this.context.getService(serviceReference);
            try {
                this.listener.added(serviceReference, service);
                return (S)service;
            }
            catch (Exception e) {
                this.context.ungetService(serviceReference);
                DeferredActivator.LOG.warn("Adding service ({}) to listener failed. Service released.", (Object)service.getClass().getName(), (Object)e);
                return null;
            }
        }

        public void modifiedService(ServiceReference<S> serviceReference, S service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<S> serviceReference, S service) {
            try {
                this.listener.removed(serviceReference, service);
            }
            finally {
                this.context.ungetService(serviceReference);
            }
        }
    }

    private static final class ServiceLookupTrackerCustomizer<S>
    implements ServiceTrackerCustomizer<S, S> {
        private final Class<S> clazz;
        private final HousekeepingActivator activator;
        private final BundleContext context;

        protected ServiceLookupTrackerCustomizer(Class<S> clazz, HousekeepingActivator activator, BundleContext context) {
            this.clazz = clazz;
            this.activator = activator;
            this.context = context;
        }

        public S addingService(ServiceReference<S> reference) {
            Object service = this.context.getService(reference);
            if (this.activator.addService(this.clazz, service)) {
                return (S)service;
            }
            DeferredActivator.LOG.error("Duplicate service instance for singleton service \"{}\" detected. Please review active/started bundles.", (Object)this.clazz.getName());
            this.context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<S> reference, S service) {
        }

        public void removedService(ServiceReference<S> reference, S service) {
            if (null != service) {
                this.activator.removeService(this.clazz);
                this.context.ungetService(reference);
            }
        }
    }
}

