/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.DefaultServiceProvider;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.osgi.ServiceProvider;
import com.openexchange.osgi.SimpleServiceProvider;
import com.openexchange.osgi.annotation.SingletonService;
import com.openexchange.osgi.console.DeferredActivatorServiceStateLookup;
import com.openexchange.osgi.console.ServiceStateLookup;
import com.openexchange.server.ServiceLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeferredActivator
implements BundleActivator,
ServiceLookup {
    static final Logger LOG = LoggerFactory.getLogger(DeferredActivator.class);
    private static final DeferredActivatorServiceStateLookup STATE_LOOKUP = new DeferredActivatorServiceStateLookup();
    protected static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected final AtomicBoolean started = new AtomicBoolean();
    private int availability;
    private int allAvailable;
    protected volatile BundleContext context;
    private ServiceTracker<?, ?>[] neededServiceTrackers;
    protected ConcurrentMap<Class<?>, ServiceProvider<?>> services;

    public static ServiceStateLookup getLookup() {
        return STATE_LOOKUP;
    }

    private <S> DeferredServiceTracker<S> newDeferredTracker(BundleContext context, Class<S> clazz, int index) {
        return new DeferredServiceTracker<S>(context, clazz, index);
    }

    protected DeferredActivator() {
    }

    protected abstract Class<?>[] getNeededServices();

    protected abstract void handleUnavailability(Class<?> var1);

    protected abstract void handleAvailability(Class<?> var1);

    private final void init(BundleContext context) throws Exception {
        this.updateServiceState();
        Class<?>[] classes = this.getNeededServices();
        if (null == classes) {
            this.services = new ConcurrentHashMap(1);
            this.neededServiceTrackers = new ServiceTracker[0];
            this.allAvailable = 0;
            this.availability = 0;
            this.startUp(false);
        } else {
            int len = classes.length;
            if (len > 0 && new HashSet(Arrays.asList(classes)).size() != len) {
                throw new IllegalArgumentException("Duplicate class/interface provided through getNeededServices()");
            }
            if (LOG.isDebugEnabled()) {
                for (Class<?> trackedService : classes) {
                    if (null != trackedService.getAnnotation(SingletonService.class) || !trackedService.getName().startsWith("com.openexchange.")) continue;
                    LOG.debug("{} tracks needed service {} that is not annotated as a {}", new Object[]{this.getClass().getName(), trackedService.getName(), SingletonService.class.getSimpleName()});
                }
            }
            this.services = new ConcurrentHashMap(len);
            this.neededServiceTrackers = new ServiceTracker[len];
            this.availability = 0;
            this.allAvailable = (1 << len) - 1;
            for (int i = 0; i < len; ++i) {
                Class<?> clazz = classes[i];
                DeferredServiceTracker<?> tracker = this.newDeferredTracker(context, clazz, i);
                tracker.open();
                if (null == this.neededServiceTrackers) continue;
                this.neededServiceTrackers[i] = tracker;
            }
            if (len == 0) {
                this.startUp(false);
            }
        }
    }

    private final void reset() {
        if (null != this.neededServiceTrackers) {
            for (int i = 0; i < this.neededServiceTrackers.length; ++i) {
                ServiceTracker<?, ?> tracker = this.neededServiceTrackers[i];
                if (tracker == null) continue;
                tracker.close();
                this.neededServiceTrackers[i] = null;
            }
            this.neededServiceTrackers = null;
        }
        this.availability = 0;
        this.allAvailable = -1;
        ConcurrentMap<Class<?>, ServiceProvider<?>> services = this.services;
        if (null != services) {
            services.clear();
            this.services = null;
        }
        this.context = null;
    }

    protected final void updateServiceState() {
        if (null == this.context) {
            return;
        }
        Class<?>[] classes = this.getNeededServices();
        if (null == classes) {
            STATE_LOOKUP.setState(this.context.getBundle().getSymbolicName(), new ArrayList<String>(0), new ArrayList<String>());
            return;
        }
        ArrayList<String> missing = new ArrayList<String>(classes.length);
        ArrayList<String> present = new ArrayList<String>(classes.length);
        for (Class<?> clazz : classes) {
            if (this.services != null && this.services.containsKey(clazz)) {
                present.add(clazz.getName());
                continue;
            }
            missing.add(clazz.getName());
        }
        STATE_LOOKUP.setState(this.context.getBundle().getSymbolicName(), missing, present);
    }

    protected final void signalAvailability(int index, Class<?> clazz) {
        this.availability |= 1 << index;
        if (this.started.get()) {
            this.handleAvailability(clazz);
        } else if (this.availability == this.allAvailable) {
            try {
                this.startUp(false);
                this.started.set(true);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t.getCause() instanceof BundleException) {
                    t = t.getCause();
                }
                final Bundle bundle = this.context.getBundle();
                final StringBuilder errorBuilder = new StringBuilder(64);
                errorBuilder.append("\nStart-up of bundle \"").append(bundle.getSymbolicName()).append("\" failed: ");
                String errorMsg = t.getMessage();
                if (null == errorMsg || "null".equals(errorMsg)) {
                    errorBuilder.append(t.getClass().getName());
                } else {
                    errorBuilder.append(errorMsg);
                }
                LOG.error(errorBuilder.toString(), t);
                this.reset();
                if (8 == bundle.getState()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DeferredActivator.shutDownBundle(bundle, errorBuilder);
                        }
                    }).start();
                }
                DeferredActivator.shutDownBundle(bundle, errorBuilder);
            }
        }
    }

    protected static void shutDownBundle(Bundle bundle, StringBuilder errorBuilder) {
        try {
            bundle.stop();
            errorBuilder.setLength(0);
            LOG.error(errorBuilder.append("\n\nBundle \"").append(bundle.getSymbolicName()).append("\" stopped.\n").toString());
        }
        catch (BundleException e) {
            errorBuilder.setLength(0);
            LOG.error(errorBuilder.append("\n\nBundle \"").append(bundle.getSymbolicName()).append("\" could not be stopped.\n").toString());
        }
    }

    final void signalUnavailability(int index, Class<?> clazz) {
        this.availability &= ~(1 << index);
        if (this.started.get()) {
            this.handleUnavailability(clazz);
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            this.context = context;
            this.init(context);
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private void startUp(boolean async) throws Exception {
        if (async) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        DeferredActivator.this.startBundle();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        LOG.error("", t);
                    }
                }
            };
            new Thread(task).run();
        } else {
            this.startBundle();
        }
    }

    protected abstract void startBundle() throws Exception;

    public void stop(BundleContext context) throws Exception {
        try {
            this.stopBundle();
            this.started.set(false);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.reset();
        }
    }

    protected abstract void stopBundle() throws Exception;

    public <S> S getService(Class<? extends S> clazz) {
        if (null == this.services) {
            return null;
        }
        ServiceProvider serviceProvider = (ServiceProvider)this.services.get(clazz);
        if (null == serviceProvider) {
            return null;
        }
        Object service = serviceProvider.getService();
        if (null == service) {
            return null;
        }
        return clazz.cast(service);
    }

    public <S> S getOptionalService(Class<? extends S> clazz) {
        ServiceReference serviceReference = this.context.getServiceReference(clazz);
        if (serviceReference == null) {
            return null;
        }
        return (S)this.context.getService(serviceReference);
    }

    protected <S> boolean addService(Class<S> clazz, S service) {
        if (null == this.services || !clazz.isInstance(service)) {
            return false;
        }
        return null == this.services.putIfAbsent(clazz, new SimpleServiceProvider<S>(service));
    }

    protected <S> boolean addServiceAlt(Class<? extends S> clazz, S service) {
        if (null == this.services || !clazz.isInstance(service)) {
            return false;
        }
        return null == this.services.putIfAbsent(clazz, new SimpleServiceProvider<S>(service));
    }

    protected <S> boolean removeService(Class<? extends S> clazz) {
        if (null == this.services) {
            return false;
        }
        return null != this.services.remove(clazz);
    }

    protected final boolean allAvailable() {
        Class<?>[] classes = this.getNeededServices();
        if (null == classes) {
            return true;
        }
        int len = classes.length;
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (this.services.containsKey(classes[i])) continue;
            return false;
        }
        return true;
    }

    private final class DeferredServiceTracker<S>
    extends ServiceTracker<S, S> {
        private static final String SERVICE_RANKING = "service.ranking";
        private final Class<? extends S> clazz;
        private final int index;

        protected DeferredServiceTracker(BundleContext context, Class<S> clazz, int index) {
            super(context, clazz, null);
            this.clazz = clazz;
            this.index = index;
        }

        public S addingService(ServiceReference<S> reference) {
            DefaultServiceProvider<Object> newProvider;
            Object service = super.addingService(reference);
            DefaultServiceProvider<Object> serviceProvider = (DefaultServiceProvider<Object>)DeferredActivator.this.services.get(this.clazz);
            if (null == serviceProvider && null == (serviceProvider = (ServiceProvider)DeferredActivator.this.services.putIfAbsent(this.clazz, newProvider = new DefaultServiceProvider<Object>()))) {
                serviceProvider = newProvider;
            }
            int ranking = 0;
            Object oRanking = reference.getProperty(SERVICE_RANKING);
            if (null != oRanking) {
                try {
                    ranking = Integer.parseInt(oRanking.toString().trim());
                }
                catch (NumberFormatException e) {
                    ranking = 0;
                }
            }
            serviceProvider.addService(service, ranking);
            DeferredActivator.this.signalAvailability(this.index, this.clazz);
            DeferredActivator.this.updateServiceState();
            return (S)service;
        }

        public void removedService(ServiceReference<S> reference, S service) {
            DeferredActivator.this.signalUnavailability(this.index, this.clazz);
            if (DeferredActivator.this.services != null) {
                DeferredActivator.this.services.remove(this.clazz);
            }
            DeferredActivator.this.updateServiceState();
            super.removedService(reference, service);
        }
    }
}

