/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum MessagingExceptionCodes implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("An error occurred: %1$s", CATEGORY_ERROR, 1, null),
    SQL_ERROR("A SQL error occurred: %1$s", CATEGORY_ERROR, 2, "Error while reading/writing data from/to the database."),
    IO_ERROR("An I/O error occurred: %1$s", CATEGORY_ERROR, 3, null),
    JSON_ERROR("A JSON error occurred: %1$s", CATEGORY_ERROR, 14, null),
    ACCOUNT_NOT_FOUND("Messaging account %1$s of service \"%2$s\" could not be found for user %3$s in context %4$s.", CATEGORY_ERROR, 4, null),
    OPERATION_NOT_SUPPORTED("The operation is not supported by service %1$s.", CATEGORY_ERROR, 6, null),
    FOLDER_NOT_FOUND("The folder \"%1$s\" cannot be found in account %2$s of service \"%3$s\" of user %4$s in context %5$s.", CATEGORY_ERROR, 7, null),
    INVALID_MESSAGE_IDENTIFIER("Invalid message identifier: %1$s", CATEGORY_ERROR, 8, null),
    INVALID_HEADER("Invalid header \"%1$s\": %2$s", CATEGORY_ERROR, 9, null),
    UNKNOWN_ACTION("Unknown action to perform: %1$s.", CATEGORY_ERROR, 10, null),
    MESSAGING_ERROR("A messaging error occurred: %1$s", CATEGORY_ERROR, 11, "A messaging error occurred: %1$s"),
    ADDRESS_ERROR("Wrongly formatted address: %1$s.", CATEGORY_ERROR, 12, "Wrongly formatted address: %1$s."),
    UNKNOWN_MESSAGING_CONTENT("Unknown messaging content: %1$s.", CATEGORY_ERROR, 14, "Unknown messaging content: %1$s."),
    UNKNOWN_MESSAGING_SERVICE("Unknown messaging service: %1$s.", CATEGORY_SERVICE_DOWN, 15, null),
    MISSING_PARAMETER("Missing parameter: %1$s.", CATEGORY_USER_INPUT, 16, null),
    INVALID_PARAMETER("Invalid parameter: %1$s with value '%2$s'.", CATEGORY_USER_INPUT, 17, "Invalid parameter: %1$s with value '%2$s'."),
    READ_ONLY("Messaging part is read-only.: %1$s", CATEGORY_USER_INPUT, 18, "Messaging part is read-only.: %1$s"),
    UNKNOWN_COLOR_LABEL("Unknown color label index: %1$s", CATEGORY_USER_INPUT, 19, "Unknown color label index: %1$s"),
    DUPLICATE_FOLDER("A duplicate folder named \"%1$s\" already exists below parent folder \"%2$s\".", CATEGORY_ERROR, 20, "A duplicate folder named \"%1$s\" already exists below parent folder \"%2$s\"."),
    NO_CREATE_ACCESS("No create access on mail folder %1$s.", CATEGORY_PERMISSION_DENIED, 21, "No create access on mail folder %1$s."),
    NOT_CONNECTED("Not connected", CATEGORY_PERMISSION_DENIED, 22, "Not connected"),
    INVALID_SORTING_COLUMN("Invalid sorting column. Cannot sort by %1$s.", CATEGORY_USER_INPUT, 23, "Invalid sorting column. Cannot sort by %1$s."),
    ATTACHMENT_NOT_FOUND("No attachment found with section identifier %1$s in message %2$s in folder %3$s.", CATEGORY_ERROR, 24, "No attachment found with section identifier %1$s in message %2$s in folder %3$s."),
    MESSAGE_NOT_FOUND("Message %1$s not found in folder %2$s.", CATEGORY_ERROR, 25, "Message %1$s not found in folder %2$s."),
    INVALID_OAUTH_ACCOUNT("Invalid OAuth account specified. OAuth account of type '%1$s' cannot be mapped to messaging service '%2$s'.", CATEGORY_ERROR, 26, "Invalid OAuth account specified.");

    private final Category category;
    private final int detailNumber;
    private final String message;
    private String displayMessage;

    private MessagingExceptionCodes(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return "MESSAGING";
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

