/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.jslob;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum JSlobExceptionCodes implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("An unexpected error occurred: %1$s", CATEGORY_ERROR, 1, null),
    JSON_ERROR("A JSON error occurred: %1$s", CATEGORY_ERROR, 2, null),
    NOT_FOUND("No JSlob storage found for identifier: %1$s", CATEGORY_ERROR, 3, null),
    NOT_FOUND_EXT("No JSlob found for service %1$s.", CATEGORY_USER_INPUT, 4, null),
    CONFLICT("Conflicting deletion of JSlob for service %1$s.", CATEGORY_USER_INPUT, 5, null),
    PATH_NOT_FOUND("Path doesn't exist: %1$s", CATEGORY_USER_INPUT, 6, null),
    INVALID_PATH("Invalid path: %1$s.", CATEGORY_USER_INPUT, 7, null),
    SET_NOT_SUPPORTED("Referenced JSlob %1$s must not be set for service %2$s. Nothing will be done.", CATEGORY_WARNING, 8, "Referenced JSlob %1$s must not be set for service %2$s. Nothing will be done."),
    RESERVED_IDENTIFIER("\"%1$s\" is a reserved identifier. Please choose a different one.", Category.EnumCategory.CATEGORY_USER_INPUT, 9, null),
    JSLOB_TOO_BIG("The JSlob %1$s is too big in context %2$d for user %3$d.", Category.EnumCategory.CATEGORY_USER_INPUT, 10, null);

    public static final String PREFIX;
    private final Category category;
    private final int number;
    private final String message;
    private String displayMessage;

    private JSlobExceptionCodes(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.number = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.number;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }

    static {
        PREFIX = "JSNCON".intern();
    }
}

