/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

public final class InterruptibleCharSequence
implements CharSequence {
    private final CharSequence inner;

    public static InterruptibleCharSequence valueOf(CharSequence charSequence) {
        if (null == charSequence) {
            return null;
        }
        if (charSequence instanceof InterruptibleCharSequence) {
            return (InterruptibleCharSequence)charSequence;
        }
        return new InterruptibleCharSequence(charSequence);
    }

    private InterruptibleCharSequence(CharSequence cs) {
        this.inner = cs;
    }

    @Override
    public char charAt(int index) {
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        return this.inner.charAt(index);
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new InterruptibleCharSequence(this.inner.subSequence(start, end));
    }

    @Override
    public String toString() {
        return ((Object)this.inner).toString();
    }
}

