/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IdMutextMap {
    public static final IdMutextMap MUTEXT_PROVIDER = new IdMutextMap();
    private final ConcurrentMap<String, MutexImpl> map = new ConcurrentHashMap<String, MutexImpl>(1024);

    private IdMutextMap() {
    }

    public Mutex getMutex(String id) {
        MutexImpl newMutex;
        if (null == id) {
            return null;
        }
        MutexImpl mutex = (MutexImpl)this.map.get(id);
        if (null == mutex && null == (mutex = this.map.putIfAbsent(id, newMutex = new MutexImpl(id)))) {
            mutex = newMutex;
        }
        return mutex;
    }

    public void shrink(final long ttl) {
        if (ttl <= 0L) {
            return;
        }
        final ConcurrentMap<String, MutexImpl> map = this.map;
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    long maxStamp = System.currentTimeMillis() - ttl;
                    Iterator it = map.values().iterator();
                    while (it.hasNext()) {
                        MutexImpl value = (MutexImpl)it.next();
                        if (value.stamp >= maxStamp) continue;
                        it.remove();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(target, IdMutextMap.class.getSimpleName() + "-Shrinker").start();
    }

    private static class MutexImpl
    implements Mutex {
        private final String id;
        private final int hash;
        final long stamp;

        MutexImpl(String id) {
            this.id = id;
            int prime = 31;
            int result = 1;
            this.hash = result = 31 * result + (id == null ? 0 : id.hashCode());
            this.stamp = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            MutexImpl other = (MutexImpl)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return this.id;
        }
    }

    public static interface Mutex {
    }
}

