/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.text.Collator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Collators {
    private static final ConcurrentMap<CollatorKey, Collator> CACHE = new ConcurrentHashMap<CollatorKey, Collator>(24);

    private Collators() {
    }

    public static Collator getDefaultInstance(Locale locale) {
        return Collators.getInstance(locale, 2);
    }

    public static Collator getSecondaryInstance(Locale locale) {
        return Collators.getInstance(locale, 1);
    }

    public static Collator getInstance(Locale locale, int strength) {
        CollatorKey key = new CollatorKey(locale, strength);
        Collator c = (Collator)CACHE.get(key);
        if (null == c) {
            Collator collator = Collator.getInstance(locale);
            collator.setStrength(strength);
            c = CACHE.putIfAbsent(key, collator);
            if (null == c) {
                c = collator;
            }
        }
        return (Collator)c.clone();
    }

    private static final class CollatorKey {
        private final int strength;
        private final Locale locale;

        CollatorKey(Locale locale, int strength) {
            this.locale = locale;
            this.strength = strength;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + this.strength;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CollatorKey)) {
                return false;
            }
            CollatorKey other = (CollatorKey)obj;
            if (this.strength != other.strength) {
                return false;
            }
            return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
        }
    }
}

