/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.Translator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nTranslator
implements Translator {
    private static final Logger LOG = LoggerFactory.getLogger(I18nTranslator.class);
    private final I18nService service;

    public I18nTranslator(I18nService service) {
        this.service = service;
    }

    @Override
    public String translate(String toTranslate) {
        if (!this.service.hasKey(toTranslate)) {
            Locale locale = this.service.getLocale();
            if (I18nTranslator.isEnUs(locale)) {
                LOG.warn("I18n service for locale {} has no translation for \"{}\".", new Object[]{locale, toTranslate, new Throwable()});
            } else {
                LOG.warn("I18n service for locale {} has no translation for \"{}\".", (Object)locale, (Object)toTranslate);
            }
            return toTranslate;
        }
        return this.service.getLocalized(toTranslate);
    }

    private static boolean isEnUs(Locale locale) {
        if (null == locale) {
            return false;
        }
        return "en".equals(locale.getLanguage()) && "US".equals(locale.getCountry());
    }
}

