/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.groupware.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum EnumComponent implements Component
{
    APPOINTMENT("APP"),
    TASK("TSK"),
    CONTACT("CON"),
    KNOWLEDGE("KNW"),
    DOCUMENT("DOC"),
    BOOKMARKS("BKM"),
    MAIL("MSG"),
    FOLDER("FLD"),
    USER_SETTING("USS"),
    LINKING("LNK"),
    REMINDER("REM"),
    ICAL("ICA"),
    VCARD("VCR"),
    PARTICIPANT("PAR"),
    GROUPUSER("GRU"),
    USER("USR"),
    GROUP("GRP"),
    AJP("AJP"),
    PRINCIPAL("PRP"),
    RESOURCE("RES"),
    INFOSTORE("IFO"),
    LOGIN("LGI"),
    DB_POOLING("DBP"),
    NONE("NON"),
    CONTEXT("CTX"),
    CACHE("CAC"),
    FILESTORE("FLS"),
    ADMIN_USER("ADM_USR"),
    ADMIN_CONTEXT("ADM_CTX"),
    ADMIN_GROUP("ADM_GRP"),
    ADMIN_RESOURCE("ADM_RES"),
    ADMIN_UTIL("ADM_UTL"),
    LDAP("LDP"),
    SERVLET("SVL"),
    CONFIGURATION("CFG"),
    TRANSACTION("TAX"),
    ATTACHMENT("ATT"),
    IMPORT_EXPORT("I_E"),
    UPLOAD("UPL"),
    UPDATE("UPD"),
    SESSION("SES"),
    SYNCML("SYN"),
    PUSHUDP("PUSHUDP"),
    SPELLCHECK("SPC"),
    ACL_ERROR("ACL"),
    PERMISSION("PERMISSION"),
    DELETE_EVENT("DEL"),
    MAIL_FILTER("MAIL_FILTER"),
    SERVICE("SRV"),
    DOWNGRADE_EVENT("DOW"),
    CONSISTENCY("CSTY"),
    AXIS2("AXIS2"),
    WEBDAV("WEBDAV"),
    HTTP_CLIENT("HC");

    private String abbreviation;
    private static final Map<String, EnumComponent> ABBREV2COMPONENT;

    private EnumComponent(String abbrevation) {
        this.abbreviation = abbrevation;
    }

    public static EnumComponent byAbbreviation(String abbrev) {
        return ABBREV2COMPONENT.get(abbrev);
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    static {
        HashMap<String, EnumComponent> tmp = new HashMap<String, EnumComponent>(EnumComponent.values().length, 1.0f);
        for (EnumComponent component : EnumComponent.values()) {
            tmp.put(component.abbreviation, component);
        }
        ABBREV2COMPONENT = Collections.unmodifiableMap(tmp);
    }
}

