/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.global.osgi;

import com.openexchange.ajax.meta.MetaContributorRegistry;
import com.openexchange.ajax.meta.internal.MetaContributorTracker;
import com.openexchange.exception.interception.OXExceptionInterceptor;
import com.openexchange.exception.interception.internal.OXExceptionInterceptorRegistration;
import com.openexchange.exception.interception.internal.OXExceptionInterceptorTracker;
import com.openexchange.exception.internal.I18nCustomizer;
import com.openexchange.global.osgi.ServerInitialization;
import com.openexchange.i18n.I18nService;
import com.openexchange.java.ConcurrentList;
import com.openexchange.server.Initialization;
import com.openexchange.server.ServiceHolderInit;
import com.openexchange.tools.strings.BasicTypesStringParser;
import com.openexchange.tools.strings.CompositeParser;
import com.openexchange.tools.strings.DateStringParser;
import com.openexchange.tools.strings.StringParser;
import com.openexchange.tools.strings.TimeSpanParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalActivator
implements BundleActivator {
    private volatile Initialization initialization;
    private volatile ServiceTracker<StringParser, StringParser> parserTracker;
    private volatile ServiceRegistration<StringParser> parserRegistration;
    private volatile ServiceRegistration<MetaContributorRegistry> metaContributorsRegistration;
    private volatile List<ServiceTracker<?, ?>> trackers;

    public void start(BundleContext context) throws Exception {
        Logger logger = LoggerFactory.getLogger(GlobalActivator.class);
        try {
            ServerInitialization initialization = new ServerInitialization();
            this.initialization = initialization;
            initialization.start();
            ServiceHolderInit.getInstance().start();
            this.initStringParsers(context);
            ArrayList trackers = new ArrayList(4);
            this.trackers = trackers;
            trackers.add(new ServiceTracker(context, I18nService.class, (ServiceTrackerCustomizer)new I18nCustomizer(context)));
            OXExceptionInterceptorRegistration.initInstance();
            trackers.add(new ServiceTracker(context, OXExceptionInterceptor.class, (ServiceTrackerCustomizer)new OXExceptionInterceptorTracker(context)));
            MetaContributorTracker metaContributors = new MetaContributorTracker(context);
            trackers.add(metaContributors);
            for (ServiceTracker serviceTracker : trackers) {
                serviceTracker.open();
            }
            this.metaContributorsRegistration = context.registerService(MetaContributorRegistry.class, (Object)metaContributors, null);
            logger.info("Global bundle successfully started");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    private void initStringParsers(final BundleContext context) {
        ServiceTracker parserTracker;
        final ConcurrentList trackedParsers = new ConcurrentList();
        ServiceTrackerCustomizer<StringParser, StringParser> customizer = new ServiceTrackerCustomizer<StringParser, StringParser>(){

            public void removedService(ServiceReference<StringParser> reference, StringParser service) {
                trackedParsers.remove((Object)service);
                context.ungetService(reference);
            }

            public void modifiedService(ServiceReference<StringParser> reference, StringParser service) {
            }

            public StringParser addingService(ServiceReference<StringParser> reference) {
                StringParser service = (StringParser)context.getService(reference);
                if (trackedParsers.add((Object)service)) {
                    return service;
                }
                context.ungetService(reference);
                return null;
            }
        };
        this.parserTracker = parserTracker = new ServiceTracker(context, StringParser.class, (ServiceTrackerCustomizer)customizer);
        final ArrayList<StringParser> standardParsers = new ArrayList<StringParser>(3);
        final CompositeParser standardParsersComposite = new CompositeParser(){

            @Override
            protected Collection<StringParser> getParsers() {
                return standardParsers;
            }
        };
        CompositeParser allParsers = new CompositeParser(){

            @Override
            protected Collection<StringParser> getParsers() {
                int size = trackedParsers.size();
                if (size <= 0) {
                    return Collections.singletonList(standardParsersComposite);
                }
                ArrayList<StringParser> parsers = new ArrayList<StringParser>(size);
                for (StringParser parser : trackedParsers) {
                    if (parser == this) {
                        trackedParsers.remove((Object)parser);
                        continue;
                    }
                    parsers.add(parser);
                }
                parsers.add(standardParsersComposite);
                return parsers;
            }
        };
        standardParsers.add(new BasicTypesStringParser());
        standardParsers.add(new DateStringParser(allParsers));
        standardParsers.add(new TimeSpanParser());
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(1);
        properties.put("service.ranking", 100);
        parserTracker.open();
        this.parserRegistration = context.registerService(StringParser.class, (Object)allParsers, properties);
    }

    public void stop(BundleContext context) throws Exception {
        Logger logger = LoggerFactory.getLogger(GlobalActivator.class);
        try {
            List<ServiceTracker<?, ?>> trackers = this.trackers;
            if (null != trackers) {
                while (!trackers.isEmpty()) {
                    trackers.remove(0).close();
                }
                this.trackers = null;
            }
            ServiceHolderInit.getInstance().stop();
            Initialization initialization = this.initialization;
            if (null != initialization) {
                initialization.stop();
                this.initialization = null;
            }
            this.shutdownStringParsers();
            ServiceRegistration<MetaContributorRegistry> metaContributorsRegistration = this.metaContributorsRegistration;
            if (null != metaContributorsRegistration) {
                metaContributorsRegistration.unregister();
                this.metaContributorsRegistration = null;
            }
            OXExceptionInterceptorRegistration.dropInstance();
            logger.debug("Global bundle successfully stopped");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    private void shutdownStringParsers() {
        ServiceTracker<StringParser, StringParser> parserTracker;
        ServiceRegistration<StringParser> parserRegistration = this.parserRegistration;
        if (null != parserRegistration) {
            parserRegistration.unregister();
            this.parserRegistration = null;
        }
        if (null != (parserTracker = this.parserTracker)) {
            parserTracker.close();
            this.parserTracker = null;
        }
    }
}

