/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception.interception.internal;

import com.openexchange.exception.interception.OXExceptionInterceptor;
import com.openexchange.exception.interception.Responsibility;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OXExceptionInterceptorRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(OXExceptionInterceptorRegistration.class);
    private static volatile OXExceptionInterceptorRegistration instance;
    private final Comparator<OXExceptionInterceptor> comparator;
    private volatile List<OXExceptionInterceptor> interceptors = new LinkedList<OXExceptionInterceptor>();

    private OXExceptionInterceptorRegistration() {
        this.comparator = new Comparator<OXExceptionInterceptor>(){

            @Override
            public int compare(OXExceptionInterceptor o1, OXExceptionInterceptor o2) {
                int rank2;
                int rank1 = o1.getRanking();
                return rank1 < (rank2 = o2.getRanking()) ? -1 : (rank1 == rank2 ? 0 : 1);
            }
        };
    }

    public static void initInstance() {
        instance = new OXExceptionInterceptorRegistration();
    }

    public static void dropInstance() {
        instance = null;
    }

    public static OXExceptionInterceptorRegistration getInstance() {
        if (instance == null) {
            OXExceptionInterceptorRegistration.initInstance();
        }
        return instance;
    }

    public synchronized void put(OXExceptionInterceptor interceptor) {
        if (interceptor == null) {
            LOG.error("Interceptor to add might not be null!");
            return;
        }
        if (this.isResponsibleInterceptorRegistered(interceptor)) {
            LOG.error("Interceptor for the given ranking " + interceptor.getRanking() + " and desired module/action combination already registered! Discard the new one from type: " + interceptor.getClass());
            return;
        }
        this.interceptors.add(interceptor);
    }

    public boolean isResponsibleInterceptorRegistered(OXExceptionInterceptor interceptorCandidate) {
        List<OXExceptionInterceptor> interceptors = this.interceptors;
        for (OXExceptionInterceptor interceptor : interceptors) {
            if (interceptor.getRanking() != interceptorCandidate.getRanking()) continue;
            for (Responsibility responsibility : interceptor.getResponsibilities()) {
                for (Responsibility candidateResponsibility : interceptorCandidate.getResponsibilities()) {
                    if (!responsibility.equals(candidateResponsibility)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void remove(OXExceptionInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    public List<OXExceptionInterceptor> getRegisteredInterceptors() {
        LinkedList<OXExceptionInterceptor> lInterceptors = new LinkedList<OXExceptionInterceptor>();
        lInterceptors.addAll(this.interceptors);
        Collections.sort(lInterceptors, this.comparator);
        return lInterceptors;
    }

    public List<OXExceptionInterceptor> getResponsibleInterceptors(String module, String action) {
        LinkedList<OXExceptionInterceptor> lInterceptors = new LinkedList<OXExceptionInterceptor>();
        for (OXExceptionInterceptor interceptor : this.interceptors) {
            if (!interceptor.isResponsible(module, action)) continue;
            lInterceptors.add(interceptor);
        }
        Collections.sort(lInterceptors, this.comparator);
        return lInterceptors;
    }
}

