/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.cli.AbstractMBeanCLI;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public abstract class AbstractContextMBeanCLI<R>
extends AbstractMBeanCLI<R> {
    protected AbstractContextMBeanCLI() {
    }

    @Override
    protected void addOptions(Options options) {
        options.addOption("c", "context", true, "A valid context identifier");
        this.addMoreOptions(options);
    }

    @Override
    protected R invoke(Options options, CommandLine cmd, MBeanServerConnection mbsc) throws Exception {
        int contextId;
        if (!cmd.hasOption('c')) {
            System.err.println("Missing context identifier.");
            this.printHelp(options);
            System.exit(1);
            return null;
        }
        String optionValue = cmd.getOptionValue('c');
        try {
            contextId = Integer.parseInt(optionValue.trim());
        }
        catch (NumberFormatException e) {
            System.err.println("Context identifier parameter is not a number: " + optionValue);
            this.printHelp(options);
            System.exit(1);
            return null;
        }
        return this.invoke(contextId, options, cmd, mbsc);
    }

    @Override
    protected boolean requiresAdministrativePermission() {
        return true;
    }

    @Override
    protected void administrativeAuth(String login, String password, CommandLine cmd, AuthenticatorMBean authenticator) throws MBeanException {
        String optionValue = cmd.getOptionValue('c');
        try {
            authenticator.doAuthentication(login, password, Integer.parseInt(optionValue.trim()));
        }
        catch (NumberFormatException e) {
            System.err.println("Context identifier parameter is not a number: ''" + optionValue + "''");
            System.exit(1);
        }
    }

    protected abstract void addMoreOptions(Options var1);

    protected abstract R invoke(int var1, Options var2, CommandLine var3, MBeanServerConnection var4) throws Exception;
}

