/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.internal.ConfigurationImpl;
import com.openexchange.config.mbean.ConfigReloadMBean;
import com.openexchange.config.mbean.ConfigReloadMBeanImpl;
import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementService;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServiceTracker
implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
    private final BundleContext context;
    private ObjectName objectName;
    private final ConfigurationImpl configService;

    ManagementServiceTracker(BundleContext context, ConfigurationImpl configService) {
        this.context = context;
        this.configService = configService;
    }

    public ManagementService addingService(ServiceReference<ManagementService> reference) {
        ManagementService management = (ManagementService)this.context.getService(reference);
        this.registerMBean(management);
        return management;
    }

    public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
    }

    public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
        ManagementService management = service;
        this.unregisterMBean(management);
        this.context.ungetService(reference);
    }

    private void registerMBean(ManagementService management) {
        if (this.objectName == null) {
            Logger logger = LoggerFactory.getLogger(ManagementServiceTracker.class);
            try {
                this.objectName = ManagementServiceTracker.getObjectName(ConfigReloadMBean.class.getName(), "com.openexchange.configuration");
                management.registerMBean(this.objectName, (Object)new ConfigReloadMBeanImpl(ConfigReloadMBean.class, this.configService));
            }
            catch (MalformedObjectNameException e) {
                logger.error("", (Throwable)e);
            }
            catch (OXException e) {
                logger.error("", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMBean(ManagementService management) {
        if (this.objectName != null) {
            Logger logger = LoggerFactory.getLogger(ManagementServiceTracker.class);
            try {
                management.unregisterMBean(this.objectName);
            }
            catch (OXException e) {
                logger.error("", (Throwable)e);
            }
            finally {
                this.objectName = null;
            }
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

