/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderDeleteListener;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class OXFolderDeleteListenerTest
extends TestCase {
    SessionObject session = null;
    int myInfostoreFolder = 0;
    int userWhichWillBeDeletedId = 0;
    int userWhichWillRemainId = 0;
    int contextAdminId = 0;
    OXFolderAccess oxfa = null;
    OXFolderManager oxma = null;
    List<FolderObject> clean = new LinkedList<FolderObject>();

    public void setUp() throws Exception {
        Init.startServer();
        Context ctx = ContextStorage.getInstance().getContext(1);
        this.userWhichWillBeDeletedId = UserStorage.getInstance().getUserId("francisco", ctx);
        this.userWhichWillRemainId = UserStorage.getInstance().getUserId("thorben", ctx);
        this.contextAdminId = ctx.getMailadmin();
        this.session = SessionObjectWrapper.createSessionObject((int)this.userWhichWillBeDeletedId, (Context)ctx, (String)"Blubb");
        this.oxfa = new OXFolderAccess(ctx);
        this.oxma = OXFolderManager.getInstance((Session)this.session);
        this.myInfostoreFolder = this.oxfa.getDefaultFolder(this.session.getUserId(), 8).getObjectID();
    }

    public void tearDown() throws Exception {
        for (FolderObject fo : this.clean) {
            this.oxma.deleteFolder(fo, false, System.currentTimeMillis());
        }
        Init.stopServer();
    }

    public void testPublicFolderTransferPermissionsToAdmin() throws OXException, OXException, OXException, OXException, SQLException, OXException {
        FolderObject testFolder = this.createPublicInfostoreSubfolderWithAdmin(this.myInfostoreFolder, this.userWhichWillBeDeletedId);
        this.clean.add(testFolder);
        testFolder = this.assignAdminPermissions(testFolder, this.userWhichWillRemainId);
        this.simulateUserDelete(this.userWhichWillBeDeletedId);
        this.checkUserInPermissionsOfFolder(testFolder.getObjectID(), this.userWhichWillRemainId);
        this.checkUserInPermissionsOfFolder(testFolder.getObjectID(), this.contextAdminId);
    }

    public void checkUserInPermissionsOfFolder(int folderId, int user) throws OXException {
        FolderObject fo = this.oxfa.getFolderObject(folderId);
        for (OCLPermission ocl : fo.getPermissions()) {
            if (ocl.getEntity() != user) continue;
            return;
        }
        OXFolderDeleteListenerTest.fail((String)("Can't find permission for user " + user + " for folder " + fo.getFolderName() + " (" + fo.getObjectID() + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateUserDelete(int deleteMe) throws OXException, OXException, OXException, SQLException, OXException {
        DeleteEvent delEvent = new DeleteEvent((Object)this, deleteMe, 1, ContextStorage.getInstance().getContext(this.session.getContextId()));
        Connection con = null;
        try {
            con = DBPool.pickupWriteable((Context)ContextStorage.getInstance().getContext(this.session.getContextId()));
            new OXFolderDeleteListener().deletePerformed(delEvent, con, con);
        }
        finally {
            DBPool.closeWriterSilent((Context)ContextStorage.getInstance().getContext(this.session.getContextId()), (Connection)con);
        }
    }

    public FolderObject assignAdminPermissions(FolderObject folder, int user) throws OXException {
        OCLPermission ocl = new OCLPermission();
        ocl.setEntity(user);
        ocl.setAllPermission(128, 128, 128, 128);
        ocl.setGroupPermission(false);
        ocl.setFolderAdmin(true);
        OCLPermission[] oldPerms = folder.getPermissionsAsArray();
        OCLPermission[] newPerms = new OCLPermission[oldPerms.length + 1];
        System.arraycopy(oldPerms, 0, newPerms, 0, oldPerms.length);
        newPerms[oldPerms.length] = ocl;
        folder.setPermissionsAsArray(newPerms);
        return this.oxma.updateFolder(folder, true, false, System.currentTimeMillis());
    }

    public FolderObject createPublicInfostoreSubfolderWithAdmin(int parentFolder, int folderAdmin) throws OXException {
        FolderObject fo = new FolderObject();
        fo.setFolderName("" + System.currentTimeMillis());
        fo.setParentFolderID(parentFolder);
        fo.setModule(8);
        fo.setType(2);
        OCLPermission ocl = new OCLPermission();
        ocl.setEntity(folderAdmin);
        ocl.setAllPermission(128, 128, 128, 128);
        ocl.setGroupPermission(false);
        ocl.setFolderAdmin(true);
        fo.setPermissionsAsArray(new OCLPermission[]{ocl});
        FolderObject created = this.oxma.createFolder(fo, true, System.currentTimeMillis());
        return created;
    }
}

