/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.CreateSubscribeTableTask;
import java.sql.SQLException;

public class CreateSubscribeTableTest
extends UpdateTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.execSafe("DROP TABLE subscriptions", new Object[0]);
        this.execSafe("DROP TABLE sequence_subscriptions", new Object[0]);
        super.tearDown();
    }

    public void testShouldCreateSubscriptionsTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id, user_id, configuration_id, source_id, folder_id, last_update FROM subscriptions", new Object[0]);
        }
        catch (SQLException x) {
            CreateSubscribeTableTest.fail((String)("Expected table subscriptions, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateSequenceTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id FROM sequence_subscriptions", new Object[0]);
        }
        catch (SQLException x) {
            CreateSubscribeTableTest.fail((String)("Expected table sequence_subscriptions, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateEntryInSequenceTableForEveryContext() throws OXException, SQLException {
        this.executeTask();
        this.assertResult("SELECT 1 FROM sequence_subscriptions WHERE cid = " + this.existing_ctx_id, new Object[0]);
    }

    private void executeTask() throws OXException {
        new CreateSubscribeTableTask().perform(this.schema, this.existing_ctx_id);
    }

    public void testShouldBeRunnableTwice() throws OXException {
        this.executeTask();
        this.executeTask();
    }
}

