/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.FolderObject;

public class Bug13995And14922Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        FolderObject folder = this.folders.createPublicFolderFor(this.session, this.ctx, "bug 13995", 2, this.userId);
        this.cleanFolders.add(folder);
        this.appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
        this.appointment.setParentFolderID(folder.getObjectID());
        this.clean.add(this.appointment);
    }

    public void testBug13995And14922() throws Exception {
        this.appointments.save(this.appointment);
        CalendarDataObject loadedAppointment = this.appointments.load(this.appointment.getObjectID(), this.appointment.getParentFolderID());
        Bug13995And14922Test.assertEquals((String)"Wrong amount of participants", (int)1, (int)loadedAppointment.getUsers().length);
        Bug13995And14922Test.assertEquals((String)"Wrong participant", (int)this.userId, (int)loadedAppointment.getUsers()[0].getIdentifier());
        Bug13995And14922Test.assertEquals((String)"Wrong status", (int)1, (int)loadedAppointment.getUsers()[0].getConfirm());
    }

    public void testBugWithoutUsers() throws Exception {
        this.appointment.removeUsers();
        this.appointments.save(this.appointment);
        CalendarDataObject loadedAppointment = this.appointments.load(this.appointment.getObjectID(), this.appointment.getParentFolderID());
        Bug13995And14922Test.assertEquals((String)"Wrong amount of participants", (int)1, (int)loadedAppointment.getUsers().length);
        Bug13995And14922Test.assertEquals((String)"Wrong participant", (int)this.userId, (int)loadedAppointment.getUsers()[0].getIdentifier());
        Bug13995And14922Test.assertEquals((String)"Wrong status", (int)1, (int)loadedAppointment.getUsers()[0].getConfirm());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

