/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import java.util.List;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;

public class Bug25160Test
extends CalDAVTest {
    private CalendarTestManager manager2;
    private FolderObject subfolder;

    public Bug25160Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
        FolderObject calendarFolder = this.manager2.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, this.manager2.getPrivateFolder())).getFolder();
        String subFolderName = "testfolder_" + Bug25160Test.randomUID();
        FolderObject folder = new FolderObject();
        folder.setFolderName(subFolderName);
        folder.setParentFolderID(calendarFolder.getObjectID());
        folder.setModule(calendarFolder.getModule());
        folder.setType(calendarFolder.getType());
        OCLPermission perm = new OCLPermission();
        perm.setEntity(this.getClient().getValues().getUserId());
        perm.setGroupPermission(false);
        perm.setAllPermission(8, 4, 4, 4);
        List permissions = calendarFolder.getPermissions();
        permissions.add(perm);
        folder.setPermissions(calendarFolder.getPermissions());
        InsertResponse response = this.manager2.getClient().execute(new InsertRequest(EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.rememberForCleanUp(folder);
        this.subfolder = folder;
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.manager2) {
            if (null != this.subfolder) {
                this.manager2.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.subfolder));
            }
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
        super.tearDown();
    }

    public void testOwner() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRINCIPAL);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/", 0, props, 0);
        MultiStatusResponse response = Bug25160Test.assertSingleResponse(super.getWebDAVClient().doPropFind(propFind));
        String currentUserPrincipal = super.extractHref(PropertyNames.CURRENT_USER_PRINCIPAL, response);
        Bug25160Test.assertNotNull((Object)currentUserPrincipal);
        if (currentUserPrincipal.endsWith("/")) {
            currentUserPrincipal = currentUserPrincipal.substring(0, currentUserPrincipal.length() - 1);
        }
        props = new DavPropertyNameSet();
        props.add(PropertyNames.OWNER);
        propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/" + this.subfolder.getObjectID(), 0, props, 0);
        response = Bug25160Test.assertSingleResponse(super.getWebDAVClient().doPropFind(propFind));
        Bug25160Test.assertTrue((String)"owner found", (boolean)response.getPropertyNames(404).contains(PropertyNames.OWNER));
    }
}

