/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.InsertParser;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertRequest
extends AbstractTaskRequest<InsertResponse> {
    private final Task task;
    private final TimeZone timeZone;
    private final boolean timeZoneParam;
    private final boolean failOnError;

    public InsertRequest(Task task, TimeZone timeZone, boolean timeZoneParam, boolean failOnError) {
        this.task = task;
        this.timeZone = timeZone;
        this.timeZoneParam = timeZoneParam;
        this.failOnError = failOnError;
    }

    public InsertRequest(Task task, TimeZone timeZone, boolean failOnError) {
        this(task, timeZone, false, failOnError);
    }

    public InsertRequest(Task task, TimeZone timeZone) {
        this(task, timeZone, false, true);
    }

    public JSONObject getBody() throws JSONException {
        return this.convert(this.task, this.timeZone);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> retval = new ArrayList<AJAXRequest.Parameter>(3);
        retval.add(new AJAXRequest.Parameter("action", "new"));
        retval.add(new AJAXRequest.Parameter("folder", String.valueOf(this.task.getParentFolderID())));
        if (this.timeZoneParam) {
            retval.add(new AJAXRequest.Parameter("timezone", this.timeZone.getID()));
        }
        return retval.toArray(new AJAXRequest.Parameter[retval.size()]);
    }

    public InsertParser getParser() {
        return new InsertParser(this.failOnError, this.task.getParentFolderID());
    }
}

