/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.resource.actions.AbstractResourceRequest;
import com.openexchange.ajax.resource.actions.ResourceNewResponse;
import com.openexchange.resource.Resource;
import com.openexchange.resource.json.ResourceWriter;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceNewRequest
extends AbstractResourceRequest<ResourceNewResponse> {
    private final JSONObject resourceJSON;
    private final boolean failOnError;

    public ResourceNewRequest(Resource createMe, boolean failOnError) throws JSONException {
        this.failOnError = failOnError;
        this.resourceJSON = ResourceWriter.writeResource((Resource)createMe);
    }

    public ResourceNewRequest(Resource resource) throws JSONException {
        this(resource, true);
    }

    @Override
    public Object getBody() throws JSONException {
        return this.resourceJSON;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "new"));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public ResourceNewParser getParser() {
        return new ResourceNewParser(this.failOnError);
    }

    private static final class ResourceNewParser
    extends AbstractAJAXParser<ResourceNewResponse> {
        ResourceNewParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ResourceNewResponse createResponse(Response response) throws JSONException {
            return new ResourceNewResponse(response);
        }
    }
}

