/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RemindAgainRequest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RemindAgainTest
extends AbstractAJAXSession {
    public RemindAgainTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemindAgain() throws Exception {
        AJAXClient client = this.getClient();
        int userId = client.getValues().getUserId();
        TimeZone timeZone = client.getValues().getTimeZone();
        int folderId = client.getValues().getPrivateTaskFolder();
        Task task = Create.createTask();
        Calendar c = TimeTools.createCalendar(timeZone);
        c.set(11, 0);
        task.setParentFolderID(folderId);
        task.setTitle("testRemindAgain");
        task.setStartDate(c.getTime());
        c.add(6, 1);
        task.setEndDate(c.getTime());
        c.add(6, -3);
        task.setAlarm(c.getTime());
        c.add(6, 2);
        Task reload = null;
        int targetId = -1;
        InsertResponse insertR = client.execute(new InsertRequest(task, timeZone));
        try {
            targetId = insertR.getId();
            GetResponse getR = TaskTools.get(client, new GetRequest(folderId, targetId));
            reload = getR.getTask(timeZone);
            ReminderObject[] reminderObjs = Executor.execute(client, new RangeRequest(c.getTime())).getReminder(timeZone);
            int pos = -1;
            for (int a = 0; a < reminderObjs.length; ++a) {
                if (reminderObjs[a].getTargetId() != targetId) continue;
                pos = a;
            }
            RemindAgainTest.assertTrue((String)"reminder not found in response", (pos > -1 ? 1 : 0) != 0);
            ReminderObject reminderObject = reminderObjs[pos];
            RemindAgainTest.assertTrue((String)"object id not found", (reminderObject.getObjectId() > 0 ? 1 : 0) != 0);
            RemindAgainTest.assertNotNull((String)"last modified is null", (Object)reminderObject.getLastModified());
            RemindAgainTest.assertEquals((String)"target id is not equal", (int)targetId, (int)reminderObject.getTargetId());
            RemindAgainTest.assertEquals((String)"folder id is not equal", (int)folderId, (int)reminderObject.getFolder());
            RemindAgainTest.assertEquals((String)"user id is not equal", (int)userId, (int)reminderObject.getUser());
            c.add(6, -2);
            Date newAlarm = c.getTime();
            reminderObject.setDate(newAlarm);
            Executor.execute(client, new RemindAgainRequest(reminderObject));
            c.add(6, 2);
            reminderObjs = Executor.execute(client, new RangeRequest(c.getTime())).getReminder(timeZone);
            pos = -1;
            for (int a = 0; a < reminderObjs.length; ++a) {
                if (reminderObjs[a].getTargetId() != targetId) continue;
                pos = a;
            }
            RemindAgainTest.assertTrue((String)"reminder not found in response", (pos > -1 ? 1 : 0) != 0);
            reminderObject = reminderObjs[pos];
            RemindAgainTest.assertTrue((String)"object id not found", (reminderObject.getObjectId() > 0 ? 1 : 0) != 0);
            RemindAgainTest.assertNotNull((String)"last modified is null", (Object)reminderObject.getLastModified());
            RemindAgainTest.assertEquals((String)"target id is not equal", (int)targetId, (int)reminderObject.getTargetId());
            RemindAgainTest.assertEquals((String)"folder id is not equal", (int)folderId, (int)reminderObject.getFolder());
            RemindAgainTest.assertEquals((String)"user id is not equal", (int)userId, (int)reminderObject.getUser());
            Date timzonedNewAlarm = new Date(newAlarm.getTime());
            int offset = timeZone.getOffset(timzonedNewAlarm.getTime());
            timzonedNewAlarm.setTime(timzonedNewAlarm.getTime() - (long)offset);
            RemindAgainTest.assertEquals((String)"alarm is not equal", (Object)timzonedNewAlarm, (Object)reminderObject.getDate());
        }
        finally {
            if (null != reload) {
                reload = TaskTools.get(client, new GetRequest(folderId, targetId)).getTask(timeZone);
                client.execute(new DeleteRequest(reload));
            }
        }
    }
}

