/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;

public class Bug19681_TimezoneForUtcProperties
extends ManagedAppointmentTest {
    String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Minter Software//EdgeDesk 4.03 MIMEDIR//EN\nMETHOD:REQUEST\nBEGIN:VEVENT\nSTATUS:CONFIRMED\nORGANIZER:MAILTO:test1@fulledtest.com\nDTSTART;TZID=America/New_York:20110701T120000\nDTEND;TZID=America/New_York:20110701T123000\nRRULE:FREQ=WEEKLY;INTERVAL=1;BYDAY=FR;WKST=SU;COUNT=10\nTRANSP:OPAQUE\nUID:250541309547419@visualmail4.webmail1\nDTSTAMP;TZID=America/New_York:20110701T192800\nDTSTAMP:20110701T192800\nSUMMARY:Test Calendar Export\nDESCRIPTION:To Ox Suppot. With Recurrences\n\nPRIORITY:5\nEND:VEVENT\nEND:VCALENDAR\n";

    public Bug19681_TimezoneForUtcProperties(String name) {
        super(name);
    }

    public void noTestErroneousFile() throws Exception {
        ICalImportResponse response = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), this.ical, false));
        Bug19681_TimezoneForUtcProperties.assertTrue((String)"Needs to fail because TZID is not allowed with DTSTAMP", (boolean)response.hasError());
    }

    public void testCorrectFile() throws Exception {
        String correct = this.ical.replace("DTSTAMP;TZID=America/New_York:20110701T192800", "DTSTAMP:20110701T192800");
        ICalImportResponse response = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), correct));
        Bug19681_TimezoneForUtcProperties.assertFalse((String)"Should run smoothly with correct DTSTAMP", (boolean)response.hasError());
        Bug19681_TimezoneForUtcProperties.assertFalse((String)"Should run smoothly with correct DTSTAMP", (boolean)response.hasConflicts());
    }
}

