/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.MultipleResponse;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class MultipleParser<T extends AbstractAJAXResponse>
extends AbstractAJAXParser<MultipleResponse<T>> {
    private final AJAXRequest<T>[] requests;

    public MultipleParser(AJAXRequest<T>[] requests) {
        super(true);
        this.requests = (AJAXRequest[])requests.clone();
    }

    @Override
    public MultipleResponse<T> parse(String body) throws JSONException {
        Response response = new Response();
        response.setData((Object)new JSONArray(body));
        return this.createResponse(response);
    }

    @Override
    protected MultipleResponse<T> createResponse(Response response) throws JSONException {
        JSONArray array = (JSONArray)response.getData();
        MultipleParser.assertEquals((String)"Multiple response array has different size.", (int)this.requests.length, (int)array.length());
        ArrayList<T> responses2 = new ArrayList<T>();
        for (int i = 0; i < this.requests.length; ++i) {
            responses2.add(this.requests[i].getParser().parse(array.getString(i)));
        }
        return new MultipleResponse(this.createArray(responses2));
    }

    private T[] createArray(List<T> list) {
        AbstractAJAXResponse test = (AbstractAJAXResponse)((Object)list.get(0));
        return list.toArray((AbstractAJAXResponse[])Array.newInstance(((Object)((Object)test)).getClass(), list.size()));
    }
}

