/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.mail;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.exception.OXException;
import com.openexchange.find.Module;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.Option;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.find.mail.MailFacetType;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.TimeZones;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.utils.DateUtils;
import com.openexchange.test.ContactTestManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;

public class BasicMailTest
extends AbstractFindTest {
    private FolderObject testFolder;
    private String defaultAddress;
    private ContactTestManager contactManager;
    private static final String MAIL = "From: #FROM#\nTo: #TO#\nCC: #TO#\nBCC: #TO#\nReceived: from ox.open-xchange.com;#DATE#\nDate: #DATE#\nSubject: #SUBJECT#\nDisposition-Notification-To: #FROM#\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nContent\n#BODY#\n";

    public BasicMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.defaultAddress = this.client.getValues().getSendAddress();
        String inboxFolder = this.client.getValues().getInboxFolder();
        String folderName = "findApiMailTestFolder_" + System.currentTimeMillis();
        this.testFolder = new FolderObject();
        this.testFolder.setModule(7);
        this.testFolder.setFullName(inboxFolder + "/" + folderName);
        this.testFolder.setFolderName(folderName);
        this.testFolder = this.folderManager.insertFolderOnServer(this.testFolder);
        this.contactManager = new ContactTestManager(this.client);
    }

    @Override
    protected void tearDown() throws Exception {
        this.contactManager.cleanUp();
        super.tearDown();
    }

    public void testAutocomplete() throws Exception {
        String prefix = this.defaultAddress.substring(0, 3);
        List<Facet> facets = this.autocomplete(prefix);
        FacetValue found = this.detectContact(facets);
        BasicMailTest.assertNotNull((String)"own contact was missing in response", (Object)found);
        ActiveFacet activeFacet = BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, found.getId(), ((Option)found.getOptions().get(0)).getFilter());
        facets = this.autocomplete(prefix, Collections.singletonList(activeFacet));
        found = this.detectContact(facets);
        BasicMailTest.assertNull((String)"Own contact should've been missing in response", (Object)found);
    }

    public void testSearch() throws Exception {
        String[][] mailIds = this.importMail(this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        ArrayList<String> addressFields = new ArrayList<String>(3);
        addressFields.add("from");
        addressFields.add("to");
        addressFields.add("cc");
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "some/id", new Filter(addressFields, this.defaultAddress)));
        facets.add(BasicMailTest.createQuery("Find me"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Did not find mail", (int)1, (int)documents.size());
        PropDocument document = documents.get(0);
        Object mailId = document.getProps().get("id");
        BasicMailTest.assertEquals((String)"Wrong mail found", (Object)mailIds[0][1], (Object)mailId);
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "some/other/id", new Filter(addressFields, "unknown@example.com")));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Mail found but should not", (int)0, (int)documents.size());
    }

    public void testMultipleGlobalFacets() throws Exception {
        String[][] mailIds = this.importMail(this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find"));
        facets.add(BasicMailTest.createQuery("me"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Did not find mail", (int)1, (int)documents.size());
        PropDocument document = documents.get(0);
        Object mailId = document.getProps().get("id");
        BasicMailTest.assertEquals((String)"Wrong mail found", (Object)mailIds[0][1], (Object)mailId);
        facets.add(BasicMailTest.createQuery("again"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Mail found but should not", (int)0, (int)documents.size());
    }

    public void testPagination() throws Exception {
        String[][] mailIds = this.importMails(3, this.defaultAddress, this.defaultAddress);
        BasicMailTest.assertNotNull((String)"mails not imported", (Object)mailIds);
        BasicMailTest.assertEquals((String)"mails not imported", (int)3, (int)mailIds.length);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "", "from", this.defaultAddress));
        List<PropDocument> documents = this.query(facets, 0, 5);
        BasicMailTest.assertEquals((String)"Should only find 3 mails", (int)3, (int)documents.size());
        documents = this.query(facets, 1, 5);
        BasicMailTest.assertEquals((String)"Should only find 2 mails", (int)2, (int)documents.size());
        documents = this.query(facets, 2, 5);
        BasicMailTest.assertEquals((String)"Should only find 1 mails", (int)1, (int)documents.size());
        documents = this.query(facets, 3, 5);
        BasicMailTest.assertEquals((String)"Should only find 0 mails", (int)0, (int)documents.size());
    }

    public void testTimeFilter() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)cal).add(3, -1);
        ((Calendar)cal).add(6, 1);
        String idWithinLastWeek = this.importMail(this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), cal.getTime())[0][1];
        cal = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)cal).add(2, -1);
        ((Calendar)cal).add(6, 1);
        String idWithinLastMonth = this.importMail(this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), cal.getTime())[0][1];
        cal = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)cal).add(1, -1);
        ((Calendar)cal).add(6, 1);
        String idWithinLastYear = this.importMail(this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), cal.getTime())[0][1];
        cal = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)cal).add(1, -1);
        ((Calendar)cal).add(6, -1);
        String idBeforeLastYear = this.importMail(this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), cal.getTime())[0][1];
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.TIME, "last_week", "time", "last_week"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 1 mails", (int)1, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.TIME, "last_month", "time", "last_month"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 2 mails", (int)2, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.TIME, "last_year", "time", "last_year"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 3 mails", (int)3, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastYear));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
    }

    public void testFilterChaining() throws Exception {
        String A = "some.body@find.me";
        String B = BasicMailTest.randomUID();
        String C = BasicMailTest.randomUID();
        String D = BasicMailTest.randomUID();
        String E = BasicMailTest.randomUID();
        String F = BasicMailTest.randomUID();
        String G = "another.dude@example.org";
        String H = BasicMailTest.randomUID();
        String I = BasicMailTest.randomUID();
        this.importMail(A, B, D);
        this.importMail(A, B, E);
        this.importMail(A, C, F);
        this.importMail(G, H, I);
        List<ActiveFacet> facets = this.prepareFacets();
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)4, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, A, "from", A));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)3, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.SUBJECT, MailFacetType.SUBJECT.getId(), "subject", B));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)2, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.MAIL_TEXT, MailFacetType.MAIL_TEXT.getId(), "body", D));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)1, (int)documents.size());
    }

    public void testPrefixItemIsLastInContactsFacet() throws Exception {
        FolderObject contactFolder = this.folderManager.generatePrivateFolder("findApiMailTestFolder_" + System.currentTimeMillis(), 3, this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId());
        contactFolder = this.folderManager.insertFolderOnServer(contactFolder);
        LinkedList<Contact> contacts = new LinkedList<Contact>();
        contacts.add(this.contactManager.newAction(this.randomContact("Marc", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marcus", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Martin", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marek", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marion", contactFolder.getObjectID())));
        String prefix = "Mar";
        List<Facet> facets = this.autocomplete(prefix);
        Facet facet = BasicMailTest.findByType((FacetType)MailFacetType.CONTACTS, facets);
        BasicMailTest.assertNotNull((String)"Contacts facet not found", (Object)facet);
        List values = ((DefaultFacet)facet).getValues();
        int nValues = values.size();
        BasicMailTest.assertTrue((String)"Missing contacts in facets", (values.size() > 5 ? 1 : 0) != 0);
        this.findContactsInValues(contacts, values);
        FacetValue last = (FacetValue)values.get(values.size() - 1);
        BasicMailTest.assertEquals((String)"Prefix item is at wrong position in result set", (String)prefix, (String)last.getId());
        facets = this.autocomplete(prefix, Collections.singletonList(new ActiveFacet((FacetType)MailFacetType.CONTACTS, ((FacetValue)values.get(0)).getId(), ((Option)((FacetValue)values.get(0)).getOptions().get(0)).getFilter())));
        facet = BasicMailTest.findByType((FacetType)MailFacetType.CONTACTS, facets);
        BasicMailTest.assertNotNull((String)"Contacts facet not found", (Object)facet);
        values = ((DefaultFacet)facet).getValues();
        BasicMailTest.assertTrue((String)"Wrong contacts in facets", (values.size() == nValues - 1 ? 1 : 0) != 0);
        last = (FacetValue)values.get(values.size() - 1);
        BasicMailTest.assertEquals((String)"Prefix item is at wrong position in result set", (String)prefix, (String)last.getId());
    }

    public void testQueryActionWithColumns() throws Exception {
        String[][] mailIds = this.importMail(this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find me"));
        int[] columns = new int[]{102, 600, 601, 602, 603, 604, 605, 607, 608, 610, 611, 614, 652, 653};
        MailListField[] fields = MailListField.getFields((int[])columns);
        List<PropDocument> documents = this.query(facets, columns);
        BasicMailTest.assertTrue((String)"Did not find mail", (documents.size() > 0 ? 1 : 0) != 0);
        PropDocument document = documents.get(0);
        LinkedList<String> jsonFields = new LinkedList<String>();
        for (MailListField field : fields) {
            jsonFields.add(field.getKey());
        }
        Map<String, Object> props = document.getProps();
        for (String jsonField : jsonFields) {
            Object value = props.remove(jsonField);
            BasicMailTest.assertNotNull((String)("Missing field " + jsonField), (Object)value);
        }
        BasicMailTest.assertTrue((String)("Document contained more fields than requested: " + props.keySet()), (props.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryActionWithoutColumns() throws Exception {
        String[][] mailIds = this.importMail(this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find me"));
        MailListField[] fields = MailField.toListFields((MailField[])MailField.FIELDS_LOW_COST);
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertTrue((String)"Did not find mail", (documents.size() > 0 ? 1 : 0) != 0);
        PropDocument document = documents.get(0);
        LinkedList<String> jsonFields = new LinkedList<String>();
        for (MailListField field : fields) {
            jsonFields.add(field.getKey());
        }
        Map<String, Object> props = document.getProps();
        for (String jsonField : jsonFields) {
            Object value = props.remove(jsonField);
            BasicMailTest.assertNotNull((String)("Missing field " + jsonField), (Object)value);
        }
        BasicMailTest.assertTrue((String)("Document contained more fields than requested: " + props.keySet()), (props.size() == 0 ? 1 : 0) != 0);
    }

    public void testTokenizedQuery() throws Exception {
        String t1 = BasicMailTest.randomUID();
        String t2 = BasicMailTest.randomUID();
        String t3 = BasicMailTest.randomUID();
        String[][] mailIds = this.importMail(this.defaultAddress, t1 + " " + t2 + " " + t3, "");
        List<ActiveFacet> facets = this.prepareFacets();
        SimpleFacet globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.MAIL, t1 + " " + t3));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        List<PropDocument> documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicMailTest.assertNotNull((String)"document not found", (Object)BasicMailTest.findByProperty(documents, "id", mailIds[0][1]));
        this.prepareFacets();
        globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.MAIL, "\"" + t1 + " " + t2 + "\""));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicMailTest.assertNotNull((String)"document not found", (Object)BasicMailTest.findByProperty(documents, "id", mailIds[0][1]));
        this.prepareFacets();
        globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.MAIL, "\"" + t1 + " " + t3 + "\""));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"document found", (0 == documents.size() ? 1 : 0) != 0);
    }

    private void findContactsInValues(List<Contact> contacts, List<FacetValue> values) {
        for (Contact contact : contacts) {
            boolean found = false;
            String contactDN = contact.getDisplayName();
            for (FacetValue value : values) {
                String valueDN = value.getDisplayItem().getDefaultValue();
                if (!contactDN.equals(valueDN)) continue;
                found = true;
                break;
            }
            BasicMailTest.assertTrue((String)("Did not find contact '" + contactDN + "'"), (boolean)found);
        }
    }

    private List<ActiveFacet> prepareFacets() {
        LinkedList<ActiveFacet> facets = new LinkedList<ActiveFacet>();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, this.testFolder.getFullName(), Filter.NO_FILTER));
        return facets;
    }

    private List<Facet> autocomplete(String prefix) throws Exception {
        return this.autocomplete(Module.MAIL, prefix);
    }

    private List<Facet> autocomplete(String prefix, List<ActiveFacet> facets) throws Exception {
        return this.autocomplete(Module.MAIL, prefix, facets);
    }

    private List<PropDocument> query(List<ActiveFacet> facets, int start, int size) throws Exception {
        return this.query(Module.MAIL, facets, start, size);
    }

    private List<PropDocument> query(List<ActiveFacet> facets) throws Exception {
        return this.query(Module.MAIL, facets);
    }

    private List<PropDocument> query(List<ActiveFacet> facets, int[] columns) throws Exception {
        return this.query(Module.MAIL, facets, columns);
    }

    private String[][] importMails(int num, String fromHeader, String toHeader) throws OXException, IOException, JSONException {
        InputStream[] streams = new InputStream[num];
        for (int i = 0; i < num; ++i) {
            String mail = MAIL.replaceAll("#FROM#", fromHeader).replaceAll("#TO#", toHeader).replaceAll("#DATE#", DateUtils.toStringRFC822((Date)new Date(), (TimeZone)TimeZones.UTC)).replaceAll("#SUBJECT#", BasicMailTest.randomUID()).replaceAll("#BODY#", BasicMailTest.randomUID());
            streams[i] = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        }
        ImportMailRequest request = new ImportMailRequest(this.testFolder.getFullName(), 0, true, true, streams);
        ImportMailResponse response = this.client.execute(request);
        return response.getIds();
    }

    private String[][] importMail(String fromHeader, String subject, String body) throws OXException, IOException, JSONException {
        return this.importMail(this.defaultAddress, fromHeader, subject, body, new Date());
    }

    private String[][] importMail(String toHeader, String fromHeader, String subject, String body, Date received) throws OXException, IOException, JSONException {
        String mail = MAIL.replaceAll("#FROM#", fromHeader).replaceAll("#TO#", toHeader).replaceAll("#DATE#", DateUtils.toStringRFC822((Date)received, (TimeZone)TimeZones.UTC)).replaceAll("#SUBJECT#", subject).replaceAll("#BODY#", body);
        ByteArrayInputStream mailStream = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        ImportMailRequest request = new ImportMailRequest(this.testFolder.getFullName(), 0, true, true, (InputStream[])new ByteArrayInputStream[]{mailStream});
        ImportMailResponse response = this.client.execute(request);
        return response.getIds();
    }

    private FacetValue detectContact(List<Facet> facets) throws OXException, IOException, JSONException {
        GetRequest getRequest = new GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone());
        GetResponse getResponse = this.client.execute(getRequest);
        Contact contact = getResponse.getContact();
        FacetValue found = BasicMailTest.findByDisplayName(facets, contact.getDisplayName());
        return found;
    }

    protected Contact randomContact(String givenName, int folderId) {
        Contact contact = new Contact();
        contact.setParentFolderID(folderId);
        contact.setSurName(BasicMailTest.randomUID());
        contact.setGivenName(givenName);
        contact.setDisplayName(contact.getGivenName() + " " + contact.getSurName());
        contact.setEmail1(BasicMailTest.randomUID() + "@example.com");
        contact.setUid(BasicMailTest.randomUID());
        return contact;
    }
}

