/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.find.actions.AbstractFindRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.find.Module;
import com.openexchange.find.calendar.CalendarFacetType;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.contacts.ContactsFacetType;
import com.openexchange.find.drive.DriveFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DisplayItem;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Facets;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.Option;
import com.openexchange.find.facet.SimpleDisplayItem;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.find.mail.MailFacetType;
import com.openexchange.find.tasks.TasksFacetType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AutocompleteRequest
extends AbstractFindRequest<AutocompleteResponse> {
    private final boolean failOnError;
    private final String prefix;
    private final String module;
    private final List<ActiveFacet> activeFacets;

    public AutocompleteRequest(String prefix, String module) {
        this(prefix, module, null, null, true);
    }

    public AutocompleteRequest(String prefix, String module, List<ActiveFacet> activeFacets) {
        this(prefix, module, activeFacets, null, true);
    }

    public AutocompleteRequest(String prefix, String module, Map<String, String> options) {
        this(prefix, module, null, options, true);
    }

    public AutocompleteRequest(String prefix, String module, List<ActiveFacet> activeFacets, Map<String, String> options, boolean failOnError) {
        super(options);
        this.failOnError = failOnError;
        this.prefix = prefix;
        this.module = module;
        this.activeFacets = activeFacets;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "autocomplete"));
        list.add(new AJAXRequest.Parameter("module", this.module));
        list.add(new AJAXRequest.Parameter("limit", Integer.MAX_VALUE));
        return list.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<? extends AutocompleteResponse> getParser() {
        return new AutocompleteParser(this.module, this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject jBody = new JSONObject(2);
        jBody.put("prefix", (Object)this.prefix);
        this.addFacets(jBody, this.activeFacets);
        this.addOptions(jBody);
        return jBody;
    }

    private static class AutocompleteParser
    extends AbstractAJAXParser<AutocompleteResponse> {
        private final String module;

        protected AutocompleteParser(String module, boolean failOnError) {
            super(failOnError);
            this.module = module;
        }

        @Override
        protected AutocompleteResponse createResponse(Response response) throws JSONException {
            JSONObject jResponse = (JSONObject)response.getData();
            ArrayList<Facet> facets = null;
            if (jResponse != null) {
                JSONArray jFacets = jResponse.getJSONArray("facets");
                int length = jFacets.length();
                facets = new ArrayList<Facet>(length);
                for (int i = 0; i < length; ++i) {
                    facets.add(this.parseJFacet(jFacets.getJSONObject(i)));
                }
            }
            return new AutocompleteResponse(response, facets);
        }

        private Facet parseJFacet(JSONObject jFacet) throws JSONException {
            int i;
            Facets.DefaultFacetBuilder builder;
            JSONArray jFacetValues;
            String id = jFacet.getString("id");
            FacetType facetType = AutocompleteParser.facetTypeFor(Module.moduleFor((String)this.module), id);
            SimpleFacet facet = null;
            if ("simple".equals(jFacet.getString("style"))) {
                Filter filter = this.parseJFilter(jFacet.getJSONObject("filter"));
                String displayName = AutocompleteParser.extractDisplayName(jFacet);
                facet = new SimpleFacet(facetType, (DisplayItem)new SimpleDisplayItem(displayName), filter);
            } else if ("default".equals(jFacet.getString("style"))) {
                jFacetValues = jFacet.getJSONArray("values");
                int len = jFacetValues.length();
                builder = Facets.newDefaultBuilder((FacetType)facetType);
                for (i = 0; i < len; ++i) {
                    builder.addValue(this.parseJFacetValue(jFacetValues.getJSONObject(i)));
                }
                facet = builder.build();
            } else if ("exclusive".equals(jFacet.getString("style"))) {
                jFacetValues = jFacet.getJSONArray("options");
                int len = jFacetValues.length();
                builder = Facets.newExclusiveBuilder((FacetType)facetType);
                for (i = 0; i < len; ++i) {
                    builder.addValue(this.parseJFacetValue(jFacetValues.getJSONObject(i)));
                }
                facet = builder.build();
            }
            JSONArray jFlags = jFacet.getJSONArray("flags");
            for (int i2 = 0; i2 < jFlags.length(); ++i2) {
                facet.addFlag(jFlags.getString(i2));
            }
            return facet;
        }

        private FacetValue parseJFacetValue(JSONObject jFacetValue) throws JSONException {
            String id = jFacetValue.getString("id");
            String displayName = AutocompleteParser.extractDisplayName(jFacetValue);
            int count = jFacetValue.optInt("count", -1);
            FacetValue.FacetValueBuilder builder = FacetValue.newBuilder((String)id).withSimpleDisplayItem(displayName).withCount(count);
            if (jFacetValue.has("filter")) {
                JSONObject jFilter = jFacetValue.getJSONObject("filter");
                builder.withFilter(this.parseJFilter(jFilter));
            } else {
                JSONArray options = jFacetValue.getJSONArray("options");
                for (int i = 0; i < options.length(); ++i) {
                    JSONObject jOption = options.getJSONObject(i);
                    builder.addOption(this.parseJOption(jOption));
                }
            }
            return builder.build();
        }

        private Option parseJOption(JSONObject jOption) throws JSONException {
            String id = jOption.optString("id");
            String displayName = AutocompleteParser.extractDisplayName(jOption);
            Filter filter = this.parseJFilter(jOption.getJSONObject("filter"));
            return Option.newInstance((String)id, (DisplayItem)new SimpleDisplayItem(displayName), (Filter)filter);
        }

        private Filter parseJFilter(JSONObject jFilter) throws JSONException {
            JSONArray jQueries = jFilter.getJSONArray("queries");
            int length = jQueries.length();
            LinkedList<String> queries = new LinkedList<String>();
            for (int i = 0; i < length; ++i) {
                queries.add(jQueries.getString(i));
            }
            JSONArray jFields = jFilter.getJSONArray("fields");
            length = jFields.length();
            LinkedList<String> fields = new LinkedList<String>();
            for (int i = 0; i < length; ++i) {
                fields.add(jFields.getString(i));
            }
            return Filter.of(fields, queries);
        }

        private static FacetType facetTypeFor(Module module, String id) {
            MailFacetType type = null;
            switch (module) {
                case MAIL: {
                    type = MailFacetType.getById((String)id);
                    break;
                }
                case CALENDAR: {
                    type = CalendarFacetType.getById((String)id);
                    break;
                }
                case CONTACTS: {
                    type = ContactsFacetType.getById((String)id);
                    break;
                }
                case DRIVE: {
                    type = DriveFacetType.getById((String)id);
                    break;
                }
                case TASKS: {
                    type = TasksFacetType.getById((String)id);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (type == null) {
                type = CommonFacetType.getById((String)id);
            }
            return type;
        }

        private static String extractDisplayName(JSONObject json) throws JSONException {
            if (json.has("display_item")) {
                JSONArray parts = (JSONArray)json.get("display_item");
                return parts.getString(0) + ' ' + parts.getString(1);
            }
            return json.optString("display_name");
        }
    }
}

