/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find;

import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.find.Document;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.DisplayItem;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.FilterBuilder;
import com.openexchange.find.facet.Option;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.test.FolderTestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public abstract class AbstractFindTest
extends AbstractAJAXSession {
    protected FolderTestManager folderManager;
    protected Random random;
    protected AJAXClient client2;
    protected FolderTestManager folderManager2;

    protected AbstractFindTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.folderManager = new FolderTestManager(this.getClient());
        this.folderManager2 = new FolderTestManager(this.client2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.folderManager.cleanUp();
        super.tearDown();
    }

    protected List<PropDocument> query(Module module, List<ActiveFacet> facets) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, module.getIdentifier());
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<PropDocument> query(Module module, List<ActiveFacet> facets, Map<String, String> options) throws Exception {
        QueryRequest queryRequest = new QueryRequest(true, 0, Integer.MAX_VALUE, facets, options, module.getIdentifier(), null);
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<PropDocument> query(Module module, List<ActiveFacet> facets, int start, int size) throws Exception {
        QueryRequest queryRequest = new QueryRequest(start, size, facets, module.getIdentifier());
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<PropDocument> query(Module module, List<ActiveFacet> facets, int[] columns) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, module.getIdentifier(), columns);
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<Facet> autocomplete(Module module, String prefix) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, module.getIdentifier());
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }

    protected List<Facet> autocomplete(Module module, String prefix, List<ActiveFacet> facets) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, module.getIdentifier(), facets);
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }

    protected String randomSubstring(String value) {
        return this.randomSubstring(value, 4);
    }

    protected String randomSubstring(String value, int minLength) {
        if (minLength >= value.length()) {
            AbstractFindTest.fail((String)(value + " is too short to get a substring from"));
        }
        int start = this.random.nextInt(value.length() - minLength);
        int stop = start + minLength + this.random.nextInt(value.length() - start - minLength);
        return value.substring(start, stop);
    }

    protected static String randomUID() {
        return UUID.randomUUID().toString();
    }

    protected static Facet findByType(FacetType type, List<Facet> facets) {
        for (Facet facet : facets) {
            if (facet.getType() != type) continue;
            return facet;
        }
        return null;
    }

    protected static FacetValue findByValueId(String valueId, DefaultFacet facet) {
        for (FacetValue value : facet.getValues()) {
            if (!valueId.equals(value.getId())) continue;
            return value;
        }
        return null;
    }

    protected static PropDocument findByProperty(List<PropDocument> documents, String property, String value) {
        for (PropDocument propDocument : documents) {
            if (!value.equals(propDocument.getProps().get(property))) continue;
            return propDocument;
        }
        return null;
    }

    protected static FacetValue findByDisplayName(List<Facet> facets, String displayName) {
        for (Facet facet : facets) {
            if (facet instanceof SimpleFacet) {
                SimpleFacet ff = (SimpleFacet)facet;
                DisplayItem displayItem = ff.getDisplayItem();
                if (!displayName.equals(displayItem.getDefaultValue())) continue;
                return new FacetValue(facet.getType().getId(), displayItem, -1, ff.getFilter());
            }
            List values = ((DefaultFacet)facet).getValues();
            for (FacetValue value : values) {
                if (!displayName.equals(value.getDisplayItem().getDefaultValue())) continue;
                return value;
            }
        }
        return null;
    }

    protected static ActiveFacet createFolderTypeFacet(FolderType type) {
        return AbstractFindTest.createActiveFacet((FacetType)CommonFacetType.FOLDER_TYPE, type.getIdentifier(), new Filter(Collections.singletonList(CommonFacetType.FOLDER_TYPE.getId()), type.getIdentifier()));
    }

    protected static ActiveFacet createQuery(String query) {
        return AbstractFindTest.createActiveFacet((FacetType)CommonFacetType.GLOBAL, CommonFacetType.GLOBAL.getId(), CommonFacetType.GLOBAL.getId(), query);
    }

    protected static ActiveFacet createActiveFacet(FacetType type, int valueId, Filter filter) {
        return new ActiveFacet(type, Integer.toString(valueId), filter);
    }

    protected static ActiveFacet createActiveFacet(FacetType type, String valueId, Filter filter) {
        return new ActiveFacet(type, valueId, filter);
    }

    protected static ActiveFacet createActiveFacet(SimpleFacet facet) {
        return new ActiveFacet(facet.getType(), facet.getType().getId(), facet.getFilter());
    }

    protected static ActiveFacet createActiveFacet(DefaultFacet facet, FacetValue value) {
        if (value.hasOptions()) {
            Option option = (Option)value.getOptions().get(0);
            return new ActiveFacet(facet.getType(), option.getId(), option.getFilter());
        }
        return new ActiveFacet(facet.getType(), value.getId(), value.getFilter());
    }

    protected static ActiveFacet createActiveFacet(FacetType type, int valueId, String field, String query) {
        Filter filter = new FilterBuilder().addField(field).addQuery(query).build();
        return new ActiveFacet(type, Integer.toString(valueId), filter);
    }

    protected static ActiveFacet createActiveFacet(FacetType type, String valueId, String field, String query) {
        Filter filter = new FilterBuilder().addField(field).addQuery(query).build();
        return new ActiveFacet(type, valueId, filter);
    }

    protected static ActiveFacet createActiveFieldFacet(FacetType type, String field, String query) {
        Filter filter = new FilterBuilder().addField(field).addQuery(query).build();
        return new ActiveFacet(type, type.getId(), filter);
    }
}

