/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.CommonUpdatesParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactUpdatesParser
extends CommonUpdatesParser<ContactUpdatesResponse> {
    protected ContactUpdatesParser(boolean failOnError, int[] columns) {
        super(failOnError, columns);
    }

    @Override
    protected ContactUpdatesResponse createResponse(Response response) throws JSONException {
        ContactUpdatesResponse retval = (ContactUpdatesResponse)super.createResponse(response);
        JSONArray rows = (JSONArray)response.getData();
        if (rows == null) {
            return retval;
        }
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            Object arrayOrId = rows.get(i);
            if (!JSONArray.class.isInstance(arrayOrId)) continue;
            JSONArray row = rows.getJSONArray(i);
            Contact contact = new Contact();
            for (int colIndex = 0; colIndex < this.getColumns().length; ++colIndex) {
                int column;
                Object value = row.get(colIndex);
                if (value == JSONObject.NULL || (column = this.getColumns()[colIndex]) == 6) continue;
                value = this.transform(value, column);
                contact.set(column, value);
            }
            contacts.add(contact);
        }
        retval.setContacts(contacts);
        return retval;
    }

    @Override
    protected ContactUpdatesResponse instantiateResponse(Response response) {
        return new ContactUpdatesResponse(response);
    }

    private Object transform(Object actual, int column) throws JSONException {
        switch (column) {
            case 4: 
            case 5: 
            case 511: 
            case 517: {
                return new Date(Autoboxing.l((Long)((Long)actual)));
            }
            case 570: {
                return ((String)actual).getBytes();
            }
            case 592: {
                return this.transformDistributionList((JSONArray)actual);
            }
        }
        return actual;
    }

    private DistributionListEntryObject[] transformDistributionList(JSONArray arr) throws JSONException {
        DistributionListEntryObject[] results = new DistributionListEntryObject[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = (JSONObject)arr.get(i);
            DistributionListEntryObject entry = new DistributionListEntryObject();
            if (obj.has("display_name")) {
                entry.setDisplayname(obj.getString("display_name"));
            }
            if (obj.has("mail")) {
                try {
                    entry.setEmailaddress(obj.getString("mail"));
                }
                catch (OXException e) {
                    // empty catch block
                }
            }
            if (!obj.has("mail_field")) continue;
            entry.setEmailfield(obj.getInt("mail_field"));
        }
        return results;
    }
}

