/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.container.Contact;
import org.json.JSONArray;

public class Bug25300Test
extends AbstractManagedContactTest {
    private Contact contact;

    public Bug25300Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contact = this.generateContact();
        this.contact.setYomiFirstName("\u30a2\u30b9\u30ab\u30ab");
        this.contact.setYomiLastName("\u30b5\u30c8\u30a6");
        this.contact.setYomiCompany("\u30b7\u30c4\u30a2\u30a2\u30a2");
        this.contact.setAddressHome("TestAddressHome 31");
        this.contact.setAddressBusiness("Test Address Business 34");
        this.contact.setAddressOther("TestAddressOther 42");
        this.manager.newAction(this.contact);
    }

    public void testYomiAndAddressFields() throws Exception {
        int[] columnIDs = new int[]{1, 20, 616, 617, 618, 619, 620, 621};
        Contact[] contacts = this.manager.allAction(this.contact.getParentFolderID(), columnIDs);
        Bug25300Test.assertNotNull((String)"got no contacts", (Object)contacts);
        Bug25300Test.assertTrue((String)"got no contacts", (0 < contacts.length ? 1 : 0) != 0);
        JSONArray arr = (JSONArray)this.manager.getLastResponse().getData();
        Bug25300Test.assertNotNull((String)"no json array in response data", (Object)arr);
        int size = arr.length();
        Bug25300Test.assertTrue((String)"no data in json array", (0 < arr.length() ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray objectData = arr.optJSONArray(i);
            Bug25300Test.assertNotNull((Object)objectData);
            int objectIdData = objectData.getInt(0);
            int folderIdData = objectData.getInt(1);
            String yomiFirstNameData = objectData.getString(2);
            String yomiLastNameData = objectData.getString(3);
            String yomiCompanyData = objectData.getString(4);
            String addressHomeData = objectData.getString(5);
            String addressBusinessData = objectData.getString(6);
            String addressOtherData = objectData.getString(7);
            Bug25300Test.assertEquals((String)"Unexpected objectId: ", (int)objectIdData, (int)this.contact.getObjectID());
            Bug25300Test.assertEquals((String)"Unexpected folderId: ", (int)folderIdData, (int)this.contact.getParentFolderID());
            Bug25300Test.assertEquals((String)"Unexpected yomiFirstName: ", (String)yomiFirstNameData, (String)this.contact.getYomiFirstName());
            Bug25300Test.assertEquals((String)"Unexpected yomiLastName: ", (String)yomiLastNameData, (String)this.contact.getYomiLastName());
            Bug25300Test.assertEquals((String)"Unexpected yomiCompany: ", (String)yomiCompanyData, (String)this.contact.getYomiCompany());
            Bug25300Test.assertEquals((String)"Unexpected addressHome: ", (String)addressHomeData, (String)this.contact.getAddressHome());
            Bug25300Test.assertEquals((String)"Unexpected addressBusiness: ", (String)addressBusinessData, (String)this.contact.getAddressBusiness());
            Bug25300Test.assertEquals((String)"Unexpected addressOther: ", (String)addressOtherData, (String)this.contact.getAddressOther());
        }
    }

    public void testBackwardCompatibilityWithExchangedColumnsId() throws Exception {
        int yomiFirstName = 610;
        int yomiLastName = 611;
        int yomiCompany = 612;
        int addressHome = 613;
        int addressBusiness = 614;
        int addressOther = 615;
        int[] columnIDs = new int[]{1, 20, 610, 611, 612, 613, 614, 615};
        Contact[] contacts = this.manager.allAction(this.contact.getParentFolderID(), columnIDs);
        Bug25300Test.assertNotNull((String)"got no contacts", (Object)contacts);
        Bug25300Test.assertTrue((String)"got no contacts", (0 < contacts.length ? 1 : 0) != 0);
        JSONArray arr = (JSONArray)this.manager.getLastResponse().getData();
        Bug25300Test.assertNotNull((String)"no json array in response data", (Object)arr);
        int size = arr.length();
        Bug25300Test.assertTrue((String)"no data in json array", (0 < arr.length() ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray objectData = arr.optJSONArray(i);
            Bug25300Test.assertNotNull((Object)objectData);
            int objectIdData = objectData.getInt(0);
            int folderIdData = objectData.getInt(1);
            String yomiFirstNameData = objectData.getString(2);
            String yomiLastNameData = objectData.getString(3);
            String yomiCompanyData = objectData.getString(4);
            String addressHomeData = objectData.getString(5);
            String addressBusinessData = objectData.getString(6);
            String addressOtherData = objectData.getString(7);
            Bug25300Test.assertEquals((String)"Unexpected objectId: ", (int)objectIdData, (int)this.contact.getObjectID());
            Bug25300Test.assertEquals((String)"Unexpected folderId: ", (int)folderIdData, (int)this.contact.getParentFolderID());
            Bug25300Test.assertEquals((String)"Unexpected yomiFirstName: ", (String)yomiFirstNameData, (String)this.contact.getYomiFirstName());
            Bug25300Test.assertEquals((String)"Unexpected yomiLastName: ", (String)yomiLastNameData, (String)this.contact.getYomiLastName());
            Bug25300Test.assertEquals((String)"Unexpected yomiCompany: ", (String)yomiCompanyData, (String)this.contact.getYomiCompany());
            Bug25300Test.assertEquals((String)"Unexpected addressHome: ", (String)addressHomeData, (String)this.contact.getAddressHome());
            Bug25300Test.assertEquals((String)"Unexpected addressBusiness: ", (String)addressBusinessData, (String)this.contact.getAddressBusiness());
            Bug25300Test.assertEquals((String)"Unexpected addressOther: ", (String)addressOtherData, (String)this.contact.getAddressOther());
        }
    }
}

