/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.BetaWriter;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.java.Autoboxing;
import java.util.Arrays;

public class Bug15354Test
extends AbstractAJAXSession {
    private static final int ITERATIONS = 10000;
    private final BetaWriter[] writer = new BetaWriter[5];
    private final Thread[] thread = new Thread[this.writer.length];
    private AJAXClient client;
    private boolean origValue;
    private Object[] origAliases;

    public Bug15354Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.client = this.getClient();
        this.origValue = this.client.execute(new GetRequest(Tree.Beta)).getBoolean();
        this.origAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)this.origAliases);
        Arrays.sort(this.origAliases);
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i] = new BetaWriter(AJAXClient.User.User1);
            this.thread[i] = new Thread(this.writer[i]);
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i].stop();
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].join();
        }
        for (i = 0; i < this.writer.length; ++i) {
            Throwable throwable = this.writer[i].getThrowable();
            Bug15354Test.assertNull((String)("Expected no Throwable, but there is one: " + throwable), (Object)throwable);
        }
        this.client.execute(new SetRequest(Tree.Beta, Autoboxing.B((boolean)this.origValue)));
        super.tearDown();
    }

    public void testAliases() throws Throwable {
        boolean stop = false;
        for (int i = 0; i < 10000 && !stop; ++i) {
            Object[] testAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
            if (null == testAliases) {
                stop = true;
            } else if (this.origAliases.length != testAliases.length) {
                stop = true;
            } else {
                Arrays.sort(testAliases);
                boolean match = true;
                for (int j = 0; j < this.origAliases.length && match; ++j) {
                    if (this.origAliases[j].equals(testAliases[j])) continue;
                    match = false;
                }
                stop = stop || !match;
            }
            for (int j = 0; j < this.writer.length; ++j) {
                stop = stop || null != this.writer[j].getThrowable();
            }
        }
        Object[] testAliases = this.client.execute(new GetRequest(Tree.MailAddresses)).getArray();
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)this.origAliases);
        Bug15354Test.assertNotNull((String)"Aliases are null.", (Object)testAliases);
        Bug15354Test.assertEquals((String)"Number of aliases are not equal.", (int)this.origAliases.length, (int)testAliases.length);
        Arrays.sort(this.origAliases);
        Arrays.sort(testAliases);
        for (int i = 0; i < this.origAliases.length; ++i) {
            Bug15354Test.assertEquals((String)"Aliases are not the same.", (Object)this.origAliases[i], (Object)testAliases[i]);
        }
    }
}

