/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;

public class TestsForDeleteExceptionsAndFixedEndsOfSeries
extends ManagedAppointmentTest {
    public TestsForDeleteExceptionsAndFixedEndsOfSeries(String name) {
        super(name);
    }

    public void testShouldNotReduceNumberOfOccurrencesWhenDeletingOneInYearlySeries() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        app.setOccurrence(5);
        Changes changes = new Changes();
        changes.put(207, (Object)5);
        Expectations expectations = new Expectations();
        expectations.put(222, (Object)5);
        expectations.put(216, null);
        this.positiveAssertionOnDeleteException.check(app, changes, expectations);
    }

    public void testShouldFailWhenDeletingBeyondScopeOfSeriesInYearlySeries() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        app.setOccurrence(5);
        Changes changes = new Changes();
        changes.put(207, (Object)6);
        this.negativeAssertionOnDeleteException.check(app, changes, new OXException(11));
    }

    public void testShouldNotReduceNumberOfOccurrencesWhenDeletingOneInMonthlySeries() throws Exception {
        Appointment app = this.generateMonthlyAppointment();
        app.setOccurrence(6);
        Changes changes = new Changes();
        changes.put(207, (Object)6);
        Expectations expectations = new Expectations();
        expectations.put(222, (Object)6);
        this.positiveAssertionOnDeleteException.check(app, changes, expectations);
    }

    public void testShouldRemoveWholeSeriesIfEverySingleOccurrenceIsDeleted() {
        Appointment app = this.generateMonthlyAppointment();
        int numberOfOccurences = 3;
        app.setOccurrence(numberOfOccurences);
        this.calendarManager.insert(app);
        for (int i = 0; i < numberOfOccurences; ++i) {
            this.calendarManager.createDeleteException(app, i + 1);
            TestsForDeleteExceptionsAndFixedEndsOfSeries.assertFalse((String)("Should not fail while creating delete exception #" + i), (boolean)this.calendarManager.hasLastException());
        }
    }
}

