/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.api2.TasksSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TaskFolderUpdaterStrategy
implements FolderUpdaterStrategy<Task> {
    private static final int SQL_INTERFACE = 1;
    private static final int TARGET = 2;
    private static final int[] COMPARISON_COLUMNS = new int[]{1, 20, 200, 201, 202, 223, 203, 5, 225};

    @Override
    public int calculateSimilarityScore(Task original, Task candidate, Object session) throws OXException {
        int score = 0;
        if ((this.isset(original.getUid()) || this.isset(candidate.getUid())) && this.eq(original.getUid(), candidate.getUid())) {
            score += 10;
        }
        if ((this.isset(original.getTitle()) || this.isset(candidate.getTitle())) && this.eq(original.getTitle(), candidate.getTitle())) {
            score += 5;
        }
        if ((this.isset(original.getNote()) || this.isset(candidate.getNote())) && this.eq(original.getNote(), candidate.getNote())) {
            score += 3;
        }
        if (original.getStartDate() != null && candidate.getStartDate() != null && this.eq(original.getStartDate(), candidate.getStartDate())) {
            score += 3;
        }
        if (original.getEndDate() != null && candidate.getEndDate() != null && this.eq(original.getEndDate(), candidate.getEndDate())) {
            score += 3;
        }
        return score;
    }

    private boolean isset(String s) {
        return s == null || s.length() > 0;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void closeSession(Object session) throws OXException {
    }

    @Override
    public Collection<Task> getData(TargetFolderDefinition target, Object session) throws OXException {
        TasksSQLInterface taskSql = (TasksSQLInterface)this.getFromSession(1, session);
        int folderId = target.getFolderIdAsInt();
        ArrayList<Task> retval = new ArrayList<Task>();
        int[] columns = Task.ALL_COLUMNS;
        ArrayList<Integer> filteredColumns = new ArrayList<Integer>();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == 6) continue;
            filteredColumns.add(columns[i]);
        }
        columns = new int[filteredColumns.size()];
        int counter = 0;
        for (Integer integer : filteredColumns) {
            columns[counter] = integer;
            ++counter;
        }
        SearchIterator tasksInFolder = taskSql.getTaskList(folderId, 0, Integer.MAX_VALUE, 0, Order.ASCENDING, columns);
        while (tasksInFolder.hasNext()) {
            retval.add((Task)tasksInFolder.next());
        }
        return retval;
    }

    @Override
    public int getThreshold(Object session) throws OXException {
        return 9;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return folder.getModule() == 1;
    }

    @Override
    public void save(Task newElement, Object session) throws OXException {
        TasksSQLInterface taskSql = (TasksSQLInterface)this.getFromSession(1, session);
        TargetFolderDefinition target = (TargetFolderDefinition)this.getFromSession(2, session);
        newElement.setParentFolderID(target.getFolderIdAsInt());
        taskSql.insertTaskObject(newElement);
    }

    private Object getFromSession(int key, Object session) {
        return ((Map)session).get(key);
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        HashMap<Integer, Object> userInfo = new HashMap<Integer, Object>();
        userInfo.put(1, new TasksSQLImpl((Session)new TargetFolderSession(target)));
        userInfo.put(2, target);
        return userInfo;
    }

    @Override
    public void update(Task original, Task update, Object session) throws OXException {
        TasksSQLInterface taskSql = (TasksSQLInterface)this.getFromSession(1, session);
        update.setParentFolderID(original.getParentFolderID());
        update.setObjectID(original.getObjectID());
        update.setLastModified(original.getLastModified());
        taskSql.updateTaskObject(update, original.getParentFolderID(), original.getLastModified());
    }
}

