/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.ifheader.IfHeader;
import com.openexchange.webdav.action.ifheader.IfHeaderParseException;
import com.openexchange.webdav.action.ifheader.IfHeaderParser;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.xml.jdom.JDOMParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public abstract class AbstractWebdavRequest
implements WebdavRequest {
    private WebdavResource res;
    private WebdavResource dest;
    private final WebdavFactory factory;
    private final Map<String, Object> userInfo = new HashMap<String, Object>();
    private Document bodyDocument;

    public AbstractWebdavRequest(WebdavFactory factory) {
        this.factory = factory;
    }

    @Override
    public WebdavResource getResource() throws WebdavProtocolException {
        if (this.res != null) {
            return this.res;
        }
        this.res = this.factory.resolveResource(this.getUrl());
        return this.res;
    }

    @Override
    public WebdavResource getDestination() throws WebdavProtocolException {
        if (null == this.getDestinationUrl()) {
            return null;
        }
        if (this.dest != null) {
            return this.dest;
        }
        this.dest = this.factory.resolveResource(this.getDestinationUrl());
        return this.dest;
    }

    @Override
    public WebdavCollection getCollection() throws WebdavProtocolException {
        if (this.res != null && this.res.isCollection()) {
            return (WebdavCollection)this.res;
        }
        this.res = this.factory.resolveCollection(this.getUrl());
        return this.res;
    }

    @Override
    public Document getBodyAsDocument() throws JDOMException, IOException {
        if (this.bodyDocument != null) {
            return this.bodyDocument;
        }
        this.bodyDocument = ServerServiceRegistry.getInstance().getService(JDOMParser.class).parse(this.getBody());
        return this.bodyDocument;
    }

    @Override
    public IfHeader getIfHeader() throws IfHeaderParseException {
        String ifHeader = this.getHeader("If");
        if (ifHeader == null) {
            return null;
        }
        return new IfHeaderParser().parse(this.getHeader("If"));
    }

    @Override
    public int getDepth(int def) {
        String depth = this.getHeader("depth");
        if (null == depth) {
            return def;
        }
        return "Infinity".equalsIgnoreCase(depth) ? -1 : Integer.parseInt(depth);
    }

    @Override
    public WebdavFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean hasBody() {
        int length;
        if (this.getHeader("Content-Length") == null) {
            return false;
        }
        try {
            length = Integer.parseInt(this.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            length = -1;
        }
        return length > 0;
    }

    @Override
    public Map<String, Object> getUserInfo() {
        return this.userInfo;
    }

    @Override
    public boolean isBrief() {
        return "t".equals(this.getHeader("Brief"));
    }
}

