/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.impl.AutoDimensionConstrain;
import com.openexchange.tools.images.impl.ContainDimensionConstrain;
import com.openexchange.tools.images.impl.CoverDimensionConstrain;
import com.openexchange.tools.images.impl.ImageInformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import com.openexchange.tools.images.transformations.TransformationContext;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ScaleTransformation
implements ImageTransformation {
    private final int maxWidth;
    private final int maxHeight;
    private final ScaleType scaleType;

    public ScaleTransformation(int maxWidth, int maxHeight, ScaleType scaleType) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.scaleType = scaleType;
    }

    @Override
    public BufferedImage perform(BufferedImage sourceImage, TransformationContext transformationContext, ImageInformation imageInformation) throws IOException {
        DimensionConstrain constrain;
        switch (this.scaleType) {
            case COVER: {
                constrain = new CoverDimensionConstrain(this.maxWidth, this.maxHeight);
                break;
            }
            case CONTAIN: {
                if (null != sourceImage && this.maxWidth >= sourceImage.getWidth() && this.maxHeight >= sourceImage.getHeight()) {
                    return sourceImage;
                }
                constrain = new ContainDimensionConstrain(this.maxWidth, this.maxHeight);
                break;
            }
            default: {
                constrain = new AutoDimensionConstrain(this.maxWidth, this.maxHeight);
            }
        }
        transformationContext.addExpense(3);
        ResampleOp resampleOp = new ResampleOp(constrain);
        resampleOp.setNumberOfThreads(1);
        return resampleOp.filter(sourceImage, null);
    }

    @Override
    public boolean needsImageInformation() {
        return false;
    }

    @Override
    public boolean supports(String formatName) {
        return true;
    }
}

