/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.internal.DefaultFileStorage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class HashingFileStorage
extends DefaultFileStorage {
    public HashingFileStorage(File storage) {
        super(storage);
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        final TreeSet<String> files = new TreeSet<String>();
        final int beginIndex = this.storage.getAbsolutePath().length() + 1;
        this.visit(new Visitor(){

            @Override
            public void visit(File f) {
                if (f.isFile()) {
                    files.add(f.getAbsolutePath().substring(beginIndex));
                }
            }
        });
        return files;
    }

    @Override
    public void recreateStateFile() throws OXException {
    }

    @Override
    public void remove() throws OXException {
        this.visit(new Visitor(){

            @Override
            public void visit(File f) {
                f.delete();
            }
        });
    }

    @Override
    public String saveNewFile(InputStream file) throws OXException {
        String string;
        FileOutputStream out = null;
        try {
            int read;
            String[] filestorePath = this.generateName();
            File path = new File(this.storage, filestorePath[0]);
            if (!(path.exists() || path.mkdirs() || path.exists())) {
                throw FileStorageCodes.CREATE_DIR_FAILED.create(path.toString());
            }
            File filePath = new File(path, filestorePath[1]);
            try {
                out = new FileOutputStream(filePath);
            }
            catch (FileNotFoundException e) {
                throw FileStorageCodes.FILE_NOT_FOUND.create(e, filePath.toString());
            }
            int buflen = 65536;
            byte[] buf = new byte[65536];
            while ((read = file.read(buf, 0, 65536)) > 0) {
                ((OutputStream)out).write(buf, 0, read);
            }
            out.flush();
            string = filestorePath[0] + '/' + filestorePath[1];
        }
        catch (IOException e) {
            try {
                throw FileStorageCodes.IOERROR.create(e, e.toString());
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{file, out});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{file, out});
        return string;
    }

    public String[] generateName() {
        int i;
        String uuid = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String prefix = Integer.toHexString(uuid.hashCode());
        StringBuilder b = new StringBuilder();
        for (i = 0; i < prefix.length() && i < 6; ++i) {
            b.append(prefix.charAt(i));
            if ((i & 1) != 1 || i <= 0) continue;
            b.append('/');
        }
        while (i < 6) {
            b.append('0');
            if ((i & 1) == 1 && i > 0) {
                b.append('/');
            }
            ++i;
        }
        b.setLength(b.length() - 1);
        return new String[]{b.toString(), uuid};
    }

    @Override
    public boolean stateFileIsCorrect() throws OXException {
        return true;
    }

    protected void visit(Visitor visitor) {
        this.recurse(this.storage, visitor);
    }

    protected void recurse(File f, Visitor visitor) {
        if (f.isFile()) {
            visitor.visit(f);
            return;
        }
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.recurse(file, visitor);
        }
        visitor.visit(f);
    }

    private static interface Visitor {
        public void visit(File var1);
    }
}

