/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.writer;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.jslob.storage.JSlobStorage;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.fields.MailAccountGetSwitch;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MailAccountWriter
implements MailAccountFields {
    private static final EnumSet<Attribute> HIDDEN_FOR_DEFAULT = EnumSet.of(Attribute.MAIL_PORT_LITERAL, new Attribute[]{Attribute.MAIL_PROTOCOL_LITERAL, Attribute.MAIL_SECURE_LITERAL, Attribute.MAIL_SERVER_LITERAL, Attribute.MAIL_URL_LITERAL, Attribute.PASSWORD_LITERAL, Attribute.LOGIN_LITERAL, Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL, Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL, Attribute.POP3_PATH_LITERAL, Attribute.POP3_REFRESH_RATE_LITERAL, Attribute.POP3_STORAGE_LITERAL, Attribute.TRANSPORT_LOGIN_LITERAL, Attribute.TRANSPORT_PASSWORD_LITERAL, Attribute.TRANSPORT_PORT_LITERAL, Attribute.TRANSPORT_PROTOCOL_LITERAL, Attribute.TRANSPORT_SECURE_LITERAL, Attribute.TRANSPORT_SERVER_LITERAL, Attribute.TRANSPORT_URL_LITERAL});
    private static volatile Boolean hideDetailsForDefaultAccount;
    private static final EnumSet<Attribute> FULL_NAMES;
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hideDetailsForDefaultAccount() {
        Boolean tmp = hideDetailsForDefaultAccount;
        if (null != tmp) return tmp;
        Class<MailAccountWriter> clazz = MailAccountWriter.class;
        synchronized (MailAccountWriter.class) {
            tmp = hideDetailsForDefaultAccount;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            hideDetailsForDefaultAccount = tmp = Boolean.valueOf(null != service && service.getBoolProperty("com.openexchange.mail.hideDetailsForDefaultAccount", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private MailAccountWriter() {
    }

    public static JSONObject write(MailAccount account) throws JSONException {
        return MailAccountWriter.write(account, MailAccountWriter.hideDetailsForDefaultAccount());
    }

    public static JSONObject write(MailAccount account, boolean hideDetailsForDefaultAccount) throws JSONException {
        JSONObject json;
        boolean hideForDefault;
        if (null == account) {
            return null;
        }
        int accountId = account.getId();
        boolean bl = hideForDefault = 0 == accountId && hideDetailsForDefaultAccount;
        if (hideForDefault) {
            json = new JSONObject(24);
            json.put("id", accountId);
            json.put("name", (Object)account.getName());
            json.put("primary_address", (Object)MailAccountWriter.addr2String(account.getPrimaryAddress()));
            json.put("personal", (Object)account.getPersonal());
            json.put("spam_handler", (Object)account.getSpamHandler());
            json.put("trash", (Object)account.getTrash());
            json.put("sent", (Object)account.getSent());
            json.put("drafts", (Object)account.getDrafts());
            json.put("spam", (Object)account.getSpam());
            json.put("confirmed_spam", (Object)account.getConfirmedSpam());
            json.put("confirmed_ham", (Object)account.getConfirmedHam());
            json.put("trash_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getTrashFullname()));
            json.put("sent_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSentFullname()));
            json.put("drafts_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getDraftsFullname()));
            json.put("spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSpamFullname()));
            json.put("confirmed_spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedSpamFullname()));
            json.put("confirmed_ham_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedHamFullname()));
            json.put("unified_inbox_enabled", account.isUnifiedINBOXEnabled());
            Map<String, String> props = account.getProperties();
            String replyTo = account.getReplyTo();
            if (null == replyTo) {
                if (props.containsKey("replyto")) {
                    json.put("reply_to", (Object)props.get("replyto"));
                }
            } else {
                json.put("reply_to", (Object)replyTo);
            }
            if (props.containsKey("addresses")) {
                json.put("addresses", (Object)props.get("addresses"));
            }
        } else {
            String replyTo;
            json = new JSONObject(48);
            json.put("id", accountId);
            json.put("login", (Object)account.getLogin());
            json.put("mail_port", account.getMailPort());
            json.put("mail_protocol", (Object)account.getMailProtocol());
            json.put("mail_secure", account.isMailSecure());
            json.put("mail_server", (Object)account.getMailServer());
            json.put("mail_url", (Object)account.generateMailServerURL());
            json.put("transport_port", account.getTransportPort());
            json.put("transport_protocol", (Object)account.getTransportProtocol());
            json.put("transport_secure", account.isTransportSecure());
            json.put("transport_server", (Object)account.getTransportServer());
            json.put("transport_url", (Object)account.generateTransportServerURL());
            json.put("transport_login", (Object)account.getTransportLogin());
            json.put("name", (Object)account.getName());
            json.put("primary_address", (Object)MailAccountWriter.addr2String(account.getPrimaryAddress()));
            json.put("personal", (Object)account.getPersonal());
            json.put("spam_handler", (Object)account.getSpamHandler());
            json.put("trash", (Object)account.getTrash());
            json.put("sent", (Object)account.getSent());
            json.put("drafts", (Object)account.getDrafts());
            json.put("spam", (Object)account.getSpam());
            json.put("confirmed_spam", (Object)account.getConfirmedSpam());
            json.put("confirmed_ham", (Object)account.getConfirmedHam());
            json.put("trash_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getTrashFullname()));
            json.put("sent_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSentFullname()));
            json.put("drafts_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getDraftsFullname()));
            json.put("spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSpamFullname()));
            json.put("confirmed_spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedSpamFullname()));
            json.put("confirmed_ham_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedHamFullname()));
            json.put("unified_inbox_enabled", account.isUnifiedINBOXEnabled());
            Map<String, String> props = account.getProperties();
            if (props.containsKey("pop3.deletewt")) {
                json.put("pop3_delete_write_through", Boolean.parseBoolean(props.get("pop3.deletewt")));
            }
            if (props.containsKey("pop3.expunge")) {
                json.put("pop3_expunge_on_quit", Boolean.parseBoolean(props.get("pop3.expunge")));
            }
            if (props.containsKey("pop3.refreshrate")) {
                json.put("pop3_refresh_rate", (Object)props.get("pop3.refreshrate"));
            }
            if (props.containsKey("pop3.storage")) {
                json.put("pop3_storage", (Object)props.get("pop3.storage"));
            }
            if (props.containsKey("pop3.path")) {
                json.put("pop3_path", (Object)props.get("pop3.path"));
            }
            if (null == (replyTo = account.getReplyTo())) {
                if (props.containsKey("replyto")) {
                    json.put("reply_to", (Object)props.get("replyto"));
                }
            } else {
                json.put("reply_to", (Object)replyTo);
            }
            if (props.containsKey("addresses")) {
                json.put("addresses", (Object)props.get("addresses"));
            }
        }
        return json;
    }

    public static JSONArray writeArray(MailAccount[] mailAccounts, List<Attribute> attributes, Session session) throws OXException {
        return MailAccountWriter.writeArray(mailAccounts, attributes, session, MailAccountWriter.hideDetailsForDefaultAccount());
    }

    public static JSONArray writeArray(MailAccount[] mailAccounts, List<Attribute> attributes, Session session, boolean hideDetailsForDefaultAccount) throws OXException {
        JSONArray rows = new JSONArray(mailAccounts.length);
        JSlobStorage jSlobStorage = AbstractMailAccountAction.getStorage();
        boolean defaultId = false;
        for (MailAccount account : mailAccounts) {
            boolean hideForDefault = hideDetailsForDefaultAccount && 0 == account.getId();
            MailAccountGetSwitch getter = new MailAccountGetSwitch(account);
            JSONArray row = new JSONArray(hideForDefault ? 32 : 64);
            for (Attribute attribute : attributes) {
                if (hideForDefault) {
                    if (HIDDEN_FOR_DEFAULT.contains((Object)attribute)) {
                        row.put(JSONObject.NULL);
                        continue;
                    }
                    MailAccountWriter.writeAttribute(attribute, account, getter, row, session, jSlobStorage);
                    continue;
                }
                if (Attribute.PASSWORD_LITERAL == attribute || Attribute.TRANSPORT_PASSWORD_LITERAL == attribute) {
                    row.put(JSONObject.NULL);
                    continue;
                }
                if (Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL == attribute || Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL == attribute) {
                    row.put(Boolean.parseBoolean(String.valueOf(attribute.doSwitch(getter))));
                    continue;
                }
                MailAccountWriter.writeAttribute(attribute, account, getter, row, session, jSlobStorage);
            }
            rows.put((Object)row);
        }
        return rows;
    }

    private static void writeAttribute(Attribute attribute, MailAccount account, MailAccountGetSwitch getter, JSONArray row, Session session, JSlobStorage jSlobStorage) throws OXException {
        if (FULL_NAMES.contains((Object)attribute)) {
            Object value = attribute.doSwitch(getter);
            if (null == value) {
                row.put(JSONObject.NULL);
            } else {
                row.put((Object)MailFolderUtility.prepareFullname(account.getId(), value.toString()));
            }
        } else if (Attribute.META == attribute) {
            JSlobId jSlobId = new JSlobId("com.openexchange.mailaccount", Integer.toString(account.getId()), session.getUserId(), session.getContextId());
            JSlob jSlob = jSlobStorage.opt(jSlobId);
            if (null == jSlob) {
                row.put(JSONObject.NULL);
            } else {
                row.put((Object)jSlob.getJsonObject());
            }
        } else if (Attribute.PRIMARY_ADDRESS_LITERAL == attribute) {
            Object value = attribute.doSwitch(getter);
            if (null == value) {
                row.put(JSONObject.NULL);
            } else {
                row.put((Object)MailAccountWriter.addr2String(value.toString()));
            }
        } else {
            Object value = attribute.doSwitch(getter);
            row.put(value == null ? JSONObject.NULL : value);
        }
    }

    private static String addr2String(String primaryAddress) {
        if (null == primaryAddress) {
            return primaryAddress;
        }
        try {
            int pos;
            QuotedInternetAddress addr = new QuotedInternetAddress(primaryAddress);
            String sAddress = addr.getAddress();
            int n = pos = null == sAddress ? 0 : sAddress.indexOf(47);
            if (pos <= 0) {
                return addr.toUnicodeString();
            }
            StringBuilder sb = new StringBuilder(32);
            String personal = addr.getPersonal();
            if (null == personal) {
                sb.append(MailAccountWriter.prepareAddress(sAddress.substring(0, pos)));
            } else {
                sb.append(MailAccountWriter.preparePersonal(personal));
                sb.append(" <").append(MailAccountWriter.prepareAddress(sAddress.substring(0, pos))).append('>');
            }
            return sb.toString();
        }
        catch (Exception e) {
            return primaryAddress;
        }
    }

    static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, false);
    }

    static String prepareAddress(String address) {
        String decoded = QuotedInternetAddress.toIDN(MimeMessageUtility.decodeMultiEncodedHeader(address));
        int pos = decoded.indexOf(DUMMY_DOMAIN);
        if (pos >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }

    static {
        FULL_NAMES = EnumSet.of(Attribute.TRASH_FULLNAME_LITERAL, new Attribute[]{Attribute.SENT_FULLNAME_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL});
    }
}

