/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.actions.AllAction;
import com.openexchange.mailaccount.json.actions.DeleteAction;
import com.openexchange.mailaccount.json.actions.GetAction;
import com.openexchange.mailaccount.json.actions.GetTreeAction;
import com.openexchange.mailaccount.json.actions.ListAction;
import com.openexchange.mailaccount.json.actions.NewAction;
import com.openexchange.mailaccount.json.actions.UpdateAction;
import com.openexchange.mailaccount.json.actions.ValidateAction;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Module(name="mailaccount", description="The mail account module is used to manage multiple mail accounts held by a user.")
public final class MailAccountActionFactory
implements AJAXActionServiceFactory {
    private static final MailAccountActionFactory SINGLETON = new MailAccountActionFactory();
    private final Map<String, AJAXActionService> actions = this.initActions();

    private MailAccountActionFactory() {
    }

    public static final MailAccountActionFactory getInstance() {
        return SINGLETON;
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        AJAXActionService retval = this.actions.get(action);
        if (null == retval) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
        }
        return retval;
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    private Map<String, AJAXActionService> initActions() {
        HashMap<String, AbstractMailAccountAction> tmp = new HashMap<String, AbstractMailAccountAction>();
        tmp.put("all", new AllAction());
        tmp.put("list", new ListAction());
        tmp.put("get", new GetAction());
        tmp.put("validate", new ValidateAction());
        tmp.put("delete", new DeleteAction());
        tmp.put("update", new UpdateAction());
        tmp.put("get_tree", new GetTreeAction());
        tmp.put("new", new NewAction());
        return Collections.unmodifiableMap(tmp);
    }
}

