/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.LoggerFactory;

final class Sanitizer {
    private Sanitizer() {
    }

    protected static void sanitize(int user, int contextId, MailAccountStorageService storageService) throws OXException {
        Sanitizer.sanitize(user, contextId, storageService, URIDefaults.IMAP, "imap://localhost:143");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void sanitize(int user, int contextId, MailAccountStorageService storageService, URIDefaults defaults, String fallbackUri) throws OXException {
        Connection con;
        try {
            con = Database.get(contextId, true);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        TIntObjectHashMap map = new TIntObjectHashMap(2);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT url, id FROM user_mail_account WHERE cid = ? AND user = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, user);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String url = rs.getString(1);
                if (URIParser.isValid(url)) continue;
                URI sanitized = URIParser.sanitize(url, defaults);
                map.put(rs.getInt(2), (Object)(null == sanitized ? fallbackUri : sanitized.toString()));
            }
            if (!map.isEmpty()) {
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = con.prepareStatement("UPDATE user_mail_account SET url = ? WHERE cid = ? AND user = ? AND id = ?");
                map.forEachEntry((TIntObjectProcedure)new AddBatchProcedure(contextId, user, stmt));
                stmt.executeBatch();
                map.forEachKey((TIntProcedure)new InvalidateProcedure(storageService, user, contextId));
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                catch (IllegalStateException e2) {
                    DBUtils.rollback(con);
                    Throwable cause = e2.getCause();
                    if (null != cause) {
                        throw MailAccountExceptionCodes.SQL_ERROR.create(cause, cause.getMessage());
                    }
                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
                catch (RuntimeException e3) {
                    DBUtils.rollback(con);
                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e3, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, true, con);
    }

    private static final class AddBatchProcedure
    implements TIntObjectProcedure<String> {
        private final int contextId;
        private final int user;
        private final PreparedStatement stmt;

        protected AddBatchProcedure(int contextId, int user, PreparedStatement stmt) {
            this.contextId = contextId;
            this.user = user;
            this.stmt = stmt;
        }

        public boolean execute(int accountId, String uri) {
            try {
                this.stmt.setString(1, uri);
                this.stmt.setInt(2, this.contextId);
                this.stmt.setInt(3, this.user);
                this.stmt.setInt(4, accountId);
                this.stmt.addBatch();
                return true;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static final class InvalidateProcedure
    implements TIntProcedure {
        private final MailAccountStorageService storageService;
        private final int user;
        private final int contextId;

        protected InvalidateProcedure(MailAccountStorageService storageService, int user, int contextId) {
            this.storageService = storageService;
            this.user = user;
            this.contextId = contextId;
        }

        public boolean execute(int accountId) {
            try {
                this.storageService.invalidateMailAccount(accountId, this.user, this.contextId);
            }
            catch (OXException e) {
                LoggerFactory.getLogger(Sanitizer.class).error("", (Throwable)e);
            }
            return true;
        }
    }
}

