/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.BooleanTerm;
import com.openexchange.mail.search.CatenatingTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Set;
import javax.mail.Message;
import javax.mail.search.AndTerm;

public final class ANDTerm
extends CatenatingTerm {
    private static final long serialVersionUID = 2696976140249947009L;

    protected ANDTerm() {
    }

    public ANDTerm(SearchTerm<?> firstTerm, SearchTerm<?> secondTerm) {
        super(firstTerm, secondTerm);
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        this.terms[0].addMailField(col);
        this.terms[1].addMailField(col);
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new AndTerm(this.terms[0].getJavaMailSearchTerm(), this.terms[1].getJavaMailSearchTerm());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new AndTerm(this.terms[0].getNonWildcardJavaMailSearchTerm(), this.terms[1].getNonWildcardJavaMailSearchTerm());
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        return this.terms[0].matches(msg) && this.terms[1].matches(msg);
    }

    @Override
    public boolean matches(MailMessage mailMessage) throws OXException {
        return this.terms[0].matches(mailMessage) && this.terms[1].matches(mailMessage);
    }

    @Override
    public SearchTerm<?> filter(Set<Class<? extends SearchTerm>> filterSet) {
        if (filterSet.contains(this.getClass())) {
            return BooleanTerm.FALSE;
        }
        ANDTerm andTerm = new ANDTerm();
        boolean replaceFirst = filterSet.contains(this.terms[0].getClass());
        if (replaceFirst) {
            andTerm.setFirstTerm(BooleanTerm.TRUE);
        } else {
            andTerm.setFirstTerm(this.terms[0].filter(filterSet));
        }
        if (filterSet.contains(this.terms[1].getClass())) {
            if (replaceFirst) {
                andTerm.setSecondTerm(BooleanTerm.FALSE);
            } else {
                andTerm.setSecondTerm(BooleanTerm.TRUE);
            }
        } else {
            andTerm.setSecondTerm(this.terms[1].filter(filterSet));
        }
        return andTerm;
    }

    @Override
    public boolean isAscii() {
        return this.terms[0].isAscii() && this.terms[1].isAscii();
    }

    @Override
    public boolean containsWildcard() {
        return this.terms[0].containsWildcard() || this.terms[1].containsWildcard();
    }
}

