/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailProviderServiceTracker
implements ServiceTrackerCustomizer<MailProvider, MailProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(MailProviderServiceTracker.class);
    private final BundleContext context;

    public MailProviderServiceTracker(BundleContext context) {
        this.context = context;
    }

    public MailProvider addingService(ServiceReference<MailProvider> reference) {
        MailProvider addedService = (MailProvider)this.context.getService(reference);
        Object protocol = reference.getProperty("protocol");
        if (null == protocol) {
            LOG.error("Missing protocol in mail provider service: {}", (Object)addedService.getClass().getName());
            this.context.ungetService(reference);
            return null;
        }
        try {
            if (!MailProviderRegistry.registerMailProvider(protocol.toString(), addedService)) {
                LOG.warn("Mail provider for protocol '{}' could not be added. Another provider which supports the protocol has already been registered.", protocol);
                this.context.ungetService(reference);
                return null;
            }
            LOG.info("Mail provider for protocol '{}' successfully registered", protocol);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            this.context.ungetService(reference);
            return null;
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<MailProvider> reference, MailProvider service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<MailProvider> reference, MailProvider service) {
        if (null != service) {
            try {
                try {
                    MailProvider provider = service;
                    MailProviderRegistry.unregisterMailProvider(provider);
                    LOG.info("Mail provider for protocol '{}' successfully unregistered", (Object)provider.getProtocol());
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

