/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.java.ExceptionAwarePipedInputStream;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeCleanUp;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MIMEMultipartMailPart;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeMailPart
extends MailPart
implements MimeRawSource,
MimeCleanUp {
    private static final long serialVersionUID = -1142595512657302179L;
    static final transient Logger LOG = LoggerFactory.getLogger(MimeMailPart.class);
    private static final int MAX_INMEMORY_SIZE = 131072;
    private static volatile Boolean useMimeMultipartMailPart;
    private static final String ERR_NULL_PART = "Underlying part is null";
    private static final int STYPE_MIME_MSG = 1;
    private static final int STYPE_MIME_BODY_MSG = 2;
    private static final int STYPE_MIME_BODY_MULTI = 3;
    private static final int STYPE_MIME_BODY = 4;
    private volatile transient Part part;
    private volatile transient MultipartWrapper multipart;
    private volatile boolean isMulti;
    private volatile boolean contentLoaded;
    private volatile int serializeType;
    private volatile byte[] serializedContent;
    private volatile String serializedContentType;
    private volatile boolean handleMissingStartBoundary;
    private static final String MULTIPART = "multipart/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean useMimeMultipartMailPart() {
        Boolean tmp = useMimeMultipartMailPart;
        if (null != tmp) return tmp;
        Class<MimeMailPart> clazz = MimeMailPart.class;
        synchronized (MimeMailPart.class) {
            tmp = useMimeMultipartMailPart;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean defaultValue = false;
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            useMimeMultipartMailPart = tmp = Boolean.valueOf(service.getBoolProperty("com.openexchange.mail.mime.useMimeMultipartMailPart", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public MimeMailPart() {
    }

    public MimeMailPart(Part part) throws OXException {
        this.applyPart(part);
    }

    public MimeMailPart(Multipart multipart) throws OXException {
        this.isMulti = true;
        this.multipart = new JavaMailMultipartWrapper(multipart);
        String contentType = multipart.getContentType();
        if (null != contentType) {
            this.setContentType(contentType);
        }
        try {
            MimeBodyPart part = new MimeBodyPart();
            MessageUtility.setContent(multipart, (Part)part);
            this.part = part;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public void setHandleMissingStartBoundary(boolean handleMissingStartBoundary) {
        this.handleMissingStartBoundary = handleMissingStartBoundary;
    }

    public void setContent(Part part) throws OXException {
        this.applyPart(part);
    }

    private void applyPart(Part part) throws OXException {
        this.part = part;
        if (null == part) {
            this.isMulti = false;
        } else {
            boolean tmp = false;
            try {
                String[] ct = part.getHeader("Content-Type");
                if (ct != null && ct.length > 0) {
                    this.setContentType(ct[0]);
                } else {
                    this.setContentType("text/plain; charset=us-ascii");
                }
                tmp = this.getContentType().startsWith(MULTIPART);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            catch (MessageRemovedException e) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            catch (MessagingException e) {
                LOG.error("", (Throwable)e);
            }
            this.isMulti = tmp;
        }
    }

    @Override
    public Part getPart() {
        return this.part;
    }

    @Override
    public void cleanUp() {
        Part part = this.part;
        if (part instanceof ManagedMimeMessage) {
            try {
                ((ManagedMimeMessage)part).cleanUp();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MimeMailPart.class).warn("Couldn't clean-up MIME resource.", (Throwable)e);
            }
        }
    }

    @Override
    public Object getContent() throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            Object obj = part.getContent();
            if (obj instanceof MimeMessage) {
                return MimeMessageConverter.convertMessage((MimeMessage)obj);
            }
            if (obj instanceof Part) {
                return MimeMessageConverter.convertPart((Part)obj, false);
            }
            return obj;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            return part.getDataHandler();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public InputStream getRawInputStream() throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            if (part instanceof MimeBodyPart) {
                return ((MimeBodyPart)part).getRawInputStream();
            }
            if (part instanceof MimeMessage) {
                return ((MimeMessage)part).getRawInputStream();
            }
            throw MailExceptionCode.NO_CONTENT.create();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws OXException {
        return this.getInputStream0(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getInputStream0(boolean handleNpe) throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return null;
        }
        try {
            PushbackInputStream in = new PushbackInputStream(part.getInputStream());
            int read = in.read();
            if (read < 0) {
                return Streams.EMPTY_INPUT_STREAM;
            }
            in.unread(read);
            return in;
        }
        catch (MessageRemovedIOException e) {
            try {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                catch (IOException e2) {
                    return this.getRawInputStream(e2);
                }
                catch (MessageRemovedException e3) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e3, new Object[0]);
                }
                catch (MessagingException e4) {
                    return this.getRawInputStream((Exception)((Object)e4));
                }
                catch (NullPointerException e5) {
                    if (!handleNpe) {
                        throw MailExceptionCode.UNEXPECTED_ERROR.create(e5, e5.getMessage());
                    }
                    InputStream in = this.sanitizeAndGetInputStream(part);
                    if (null == in) {
                        throw MailExceptionCode.UNEXPECTED_ERROR.create(e5, e5.getMessage());
                    }
                    return in;
                }
            }
            catch (MessagingException e6) {
                throw MimeMailException.handleMessagingException(e6);
            }
        }
    }

    private InputStream sanitizeAndGetInputStream(Part part) throws OXException {
        try {
            Part p = part;
            String cts = MimeMessageUtility.getHeader("Content-Type", null, p);
            if (null == cts) {
                return null;
            }
            if (p.getClass().getName().startsWith("com.sun.mail.imap.IMAP")) {
                this.loadContent();
                p = this.part;
            }
            p.setHeader("Content-Type", new ContentType(cts).toString(true));
        }
        catch (Exception x) {
            return null;
        }
        return this.getInputStream0(false);
    }

    private InputStream getRawInputStream(Exception e) throws MessagingException, OXException {
        try {
            LOG.debug("Part's input stream could not be obtained. Trying to read from part's raw input stream instead", (Throwable)e);
            Part part = this.part;
            if (part instanceof MimeBodyPart) {
                return ((MimeBodyPart)part).getRawInputStream();
            }
            if (part instanceof MimeMessage) {
                return ((MimeMessage)part).getRawInputStream();
            }
            if (e instanceof MessagingException) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException me) {
            me.setNextException(e);
            throw me;
        }
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            return this.getMultipartWrapper().getMailPart(index);
        }
        return null;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.isMulti) {
            if (this.handleMissingStartBoundary) {
                MultipartWrapper wrapper = this.getMultipartWrapper();
                try {
                    return wrapper.getCount();
                }
                catch (OXException e) {
                    return this.handleMissingStartBoundary(e);
                }
            }
            return this.getMultipartWrapper().getCount();
        }
        return -1;
    }

    private int handleMissingStartBoundary(OXException e) throws OXException {
        Throwable cause = e.getCause();
        if (!(cause instanceof MessagingException) || !"Missing start boundary".equals(((MessagingException)cause).getMessage())) {
            throw e;
        }
        try {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
            Part part = this.part;
            part.writeTo((OutputStream)out);
            MIMEMultipartWrapper multipart = new MIMEMultipartWrapper(new MIMEMultipartMailPart(this.getContentType(), part.getDataHandler().getDataSource()));
            this.multipart = multipart;
            return multipart.getCount();
        }
        catch (IOException e1) {
            LOG.error("", (Throwable)e1);
            throw e;
        }
        catch (MessagingException e1) {
            LOG.error("", (Throwable)e1);
            throw e;
        }
    }

    @Override
    public void writeTo(OutputStream out) throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        try {
            if (part instanceof MimeMessage && !(part instanceof IMAPMessage)) {
                this.saneContentType();
            }
            part.writeTo(out);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            if ("No content".equals(e.getMessage())) {
                throw MailExceptionCode.NO_CONTENT.create(e, new Object[0]);
            }
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private void saneContentType() throws MessagingException {
        Part part = this.part;
        String[] header = part.getHeader("Content-Type");
        if (null != header && header.length > 0) {
            try {
                part.setHeader("Content-Type", new ContentType(header[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void prepareForCaching() {
        if (!this.contentLoaded) {
            this.multipart = null;
            this.part = null;
        }
    }

    @Override
    public void loadContent() throws OXException {
        Part part = this.part;
        if (null == part) {
            throw new IllegalStateException(ERR_NULL_PART);
        }
        if (this.contentLoaded) {
            return;
        }
        try {
            if (part instanceof MimeBodyPart) {
                String[] ct = part.getHeader("Content-Type");
                ContentType contentType = ct != null && ct.length > 0 ? new ContentType(ct[0]) : new ContentType("text/plain; charset=us-ascii");
                if (contentType.startsWith(MULTIPART)) {
                    this.part = part = MimeMailPart.createBodyMultipart(MimeMailPart.getStreamFromMultipart(MimeMailPart.getMultipartContentFrom(part, contentType.toString())), contentType.toString());
                    this.multipart = null;
                    this.contentLoaded = true;
                } else if (contentType.startsWith("message/rfc822")) {
                    this.part = part = MimeMailPart.createBodyMessage(MimeMailPart.getStreamFromPart((Part)((Message)part.getContent())));
                    this.contentLoaded = true;
                } else {
                    this.part = part = MimeMailPart.createBodyPart(MimeMailPart.getStreamFromPart(part));
                    this.contentLoaded = true;
                }
            } else if (part instanceof MimeMessage) {
                this.part = part = MimeMailPart.createMessage(MimeMailPart.getStreamFromPart(part));
                this.multipart = null;
                this.contentLoaded = true;
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
            MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static Multipart getMultipartContentFrom(Part part, String contentType) throws MessagingException, IOException {
        return MimeMessageUtility.getMultipartContentFrom(part, contentType);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.multipart = null;
        Part part = this.part;
        if (part == null) {
            this.serializeType = 0;
            this.serializedContent = null;
            out.defaultWriteObject();
            return;
        }
        try {
            if (part instanceof MimeBodyPart) {
                String[] ct = part.getHeader("Content-Type");
                ContentType contentType = ct != null && ct.length > 0 ? new ContentType(ct[0]) : new ContentType("text/plain; charset=us-ascii");
                if (contentType.startsWith(MULTIPART)) {
                    this.serializeType = 3;
                    this.serializedContent = MimeMailPart.getBytesFromMultipart(MimeMailPart.getMultipartContentFrom(part, contentType.toString()));
                    this.serializedContentType = contentType.toString();
                } else if (contentType.startsWith("message/rfc822")) {
                    this.serializeType = 2;
                    this.serializedContent = MimeMailPart.getBytesFromPart((Part)((Message)part.getContent()));
                } else {
                    this.serializeType = 4;
                    this.serializedContent = MimeMailPart.getBytesFromPart(part);
                }
            } else if (part instanceof MimeMessage) {
                this.serializeType = 1;
                this.serializedContent = MimeMailPart.getBytesFromPart(part);
            }
            out.defaultWriteObject();
        }
        catch (OXException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (MessagingException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.serializeType = 0;
            this.serializedContent = null;
            this.serializedContentType = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int serializeType = this.serializeType;
        if (serializeType > 0) {
            try {
                byte[] serializedContent = this.serializedContent;
                if (2 == serializeType) {
                    this.part = MimeMailPart.createBodyMessage(Streams.newByteArrayInputStream((byte[])serializedContent));
                    this.contentLoaded = true;
                } else if (3 == serializeType) {
                    this.part = MimeMailPart.createBodyMultipart(Streams.newByteArrayInputStream((byte[])serializedContent), this.serializedContentType);
                    this.multipart = null;
                    this.contentLoaded = true;
                } else if (4 == serializeType) {
                    this.part = MimeMailPart.createBodyPart(Streams.newByteArrayInputStream((byte[])serializedContent));
                    this.contentLoaded = true;
                } else if (1 == serializeType) {
                    this.part = MimeMailPart.createMessage(Streams.newByteArrayInputStream((byte[])serializedContent));
                    this.contentLoaded = true;
                }
            }
            catch (MessagingException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                this.serializeType = 0;
                this.serializedContent = null;
                this.serializedContentType = null;
            }
        }
    }

    private static MimeBodyPart createBodyMessage(InputStream data) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        MessageUtility.setContent((Message)new MimeMessage(MimeDefaultSession.getDefaultSession(), data), (Part)mimeBodyPart);
        return mimeBodyPart;
    }

    private static MimeBodyPart createBodyMultipart(InputStream data, String contentType) throws MessagingException, IOException {
        if (null == data) {
            return null;
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        MessageUtility.setContent((Multipart)new MimeMultipart((DataSource)new MessageDataSource(data, contentType)), (Part)mimeBodyPart);
        return mimeBodyPart;
    }

    private static MimeBodyPart createBodyPart(InputStream data) throws MessagingException {
        return new MimeBodyPart(data);
    }

    private static MimeMessage createMessage(InputStream data) throws MessagingException {
        return new MimeMessage(MimeDefaultSession.getDefaultSession(), data);
    }

    private static InputStream getStreamFromPart(final Part part) throws IOException {
        if (null == part) {
            return null;
        }
        final PipedOutputStream pos = new PipedOutputStream();
        final ExceptionAwarePipedInputStream pin = new ExceptionAwarePipedInputStream(pos, 65536);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    part.writeTo((OutputStream)pos);
                }
                catch (Exception e) {
                    pin.setException(e);
                }
                finally {
                    Streams.close((Closeable)pos);
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            new Thread(r, "MimeMailPart.getStreamFromPart").start();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), AbortBehavior.getInstance());
        }
        return MimeMailPart.stripEmptyStartingLine((InputStream)pin);
    }

    private static InputStream getStreamFromMultipart(final Multipart multipart) throws IOException {
        if (null == multipart) {
            return null;
        }
        final PipedOutputStream pos = new PipedOutputStream();
        final ExceptionAwarePipedInputStream pin = new ExceptionAwarePipedInputStream(pos, 65536);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    multipart.writeTo((OutputStream)pos);
                }
                catch (Exception e) {
                    pin.setException(e);
                }
                finally {
                    Streams.close((Closeable)pos);
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            new Thread(r, "MimeMailPart.getStreamFromMultipart").start();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), AbortBehavior.getInstance());
        }
        return MimeMailPart.stripEmptyStartingLine((InputStream)pin);
    }

    private static InputStream stripEmptyStartingLine(InputStream data) throws IOException {
        if (null == data) {
            return data;
        }
        PushbackInputStream in = new PushbackInputStream(data);
        int read = in.read();
        while (Strings.isWhitespace((char)((char)read))) {
            read = in.read();
            if (read >= 0) continue;
            Streams.close((Closeable)in);
            throw new IOException("Unexpected end of stream");
        }
        in.unread(read);
        return in;
    }

    private static byte[] getBytesFromPart(Part part) throws IOException, MessagingException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
        part.writeTo((OutputStream)out);
        byte[] data = out.toByteArray();
        return MimeMailPart.stripEmptyStartingLine(data);
    }

    private static byte[] getBytesFromMultipart(Multipart multipart) throws IOException, MessagingException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
        multipart.writeTo((OutputStream)out);
        byte[] data = out.toByteArray();
        return MimeMailPart.stripEmptyStartingLine(data);
    }

    private static byte[] stripEmptyStartingLine(byte[] data) {
        if (null == data || data.length <= 1) {
            return data;
        }
        int start = 0;
        if (data[start] == 13) {
            ++start;
        }
        if (data[start] == 10) {
            ++start;
        }
        if (start > 0) {
            byte[] data0 = new byte[data.length - start];
            System.arraycopy(data, start, data0, 0, data0.length);
            return data0;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipartWrapper getMultipartWrapper() throws OXException {
        MultipartWrapper multipart = this.multipart;
        if (null == multipart) {
            MimeMailPart mimeMailPart = this;
            synchronized (mimeMailPart) {
                multipart = this.multipart;
                if (null == multipart) {
                    try {
                        int size;
                        Part part = this.part;
                        if (MimeMailPart.useMimeMultipartMailPart() && (size = part.getSize()) > 0 && size <= 131072) {
                            ByteArrayOutputStream out = Streams.newByteArrayOutputStream((int)size);
                            part.writeTo((OutputStream)out);
                            this.multipart = multipart = new MIMEMultipartWrapper(new MIMEMultipartMailPart(this.getContentType(), out.toByteArray()));
                        } else {
                            Object content = part.getContent();
                            if (content instanceof Multipart) {
                                this.multipart = multipart = new JavaMailMultipartWrapper((Multipart)content);
                            } else {
                                if (content instanceof InputStream) {
                                    MimeMailPart.closeQuitely((InputStream)content);
                                }
                                this.loadContent();
                                part = this.part;
                                String headerName = "Content-Type";
                                String[] header = part.getHeader("Content-Type");
                                if (null != header) {
                                    part.setHeader("Content-Type", new ContentType(header[0]).toString());
                                }
                                this.multipart = multipart = new JavaMailMultipartWrapper(MimeMessageConverter.multipartFor(part.getContent(), this.getContentType()));
                            }
                        }
                    }
                    catch (MessagingException e) {
                        throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
                        MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
                        throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
                    }
                    catch (IOException e) {
                        if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                    }
                    catch (ClassCastException e) {
                        LOG.debug("Message's Content-Type indicates to be multipart/* but its content is not an instance of javax.mail.Multipart but {}", (Object)e.getMessage());
                        throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
                    }
                }
            }
        }
        return multipart;
    }

    private static void closeQuitely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.trace("", (Throwable)e);
        }
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                useMimeMultipartMailPart = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
    }

    private static class JavaMailMultipartWrapper
    implements MultipartWrapper {
        private final Multipart jmMultipart;

        public JavaMailMultipartWrapper(Multipart multipart) {
            this.jmMultipart = multipart;
        }

        @Override
        public int getCount() throws OXException {
            try {
                return this.jmMultipart.getCount();
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }

        @Override
        public MailPart getMailPart(int index) throws OXException {
            try {
                return MimeMessageConverter.convertPart((Part)this.jmMultipart.getBodyPart(index), false);
            }
            catch (MessagingException e) {
                throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static class MIMEMultipartWrapper
    implements MultipartWrapper {
        private final MIMEMultipartMailPart multipartMailPart;

        public MIMEMultipartWrapper(MIMEMultipartMailPart multipartMailPart) {
            this.multipartMailPart = multipartMailPart;
        }

        @Override
        public int getCount() throws OXException {
            return this.multipartMailPart.getEnclosedCount();
        }

        @Override
        public MailPart getMailPart(int index) throws OXException {
            return this.multipartMailPart.getEnclosedMailPart(index);
        }
    }

    private static interface MultipartWrapper {
        public int getCount() throws OXException;

        public MailPart getMailPart(int var1) throws OXException;
    }
}

