/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class HeaderOutputStream
extends ByteArrayOutputStream {
    private int lfCount = 0;
    private boolean discard = false;

    public HeaderOutputStream() {
        this(32);
        this.lfCount = 0;
        this.discard = false;
    }

    public HeaderOutputStream(int size) {
        super(size);
    }

    @Override
    public void write(int b) {
        if (this.discard) {
            return;
        }
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
        if (10 == b) {
            if (++this.lfCount >= 2) {
                this.discard = true;
            }
        } else if (13 != b) {
            this.lfCount = 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bLen = off + len;
        if (bLen > b.length || bLen < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0 || this.discard) {
            return;
        }
        int pos = -1;
        for (int i = off; pos < 0 && i < bLen; ++i) {
            if (10 == b[i]) {
                if (++this.lfCount < 2) continue;
                this.discard = true;
                pos = i;
                continue;
            }
            if (13 == b[i]) continue;
            this.lfCount = 0;
        }
        int nlen = pos < 0 ? len : pos - off + 1;
        int newcount = this.count + nlen;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, nlen);
        this.count = newcount;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (null != out) {
            out.write(this.buf, 0, this.count);
        }
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public byte[] toByteArray(int off, int size) {
        if (off < 0 || off > this.count || size < 0 || off + size > this.count || off + size < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] newbuf = new byte[size];
        System.arraycopy(this.buf, off, newbuf, 0, size);
        return newbuf;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    @Override
    @Deprecated
    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }
}

