/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ParameterList;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public abstract class ParameterizedHeader
implements Serializable,
Comparable<ParameterizedHeader> {
    private static final long serialVersionUID = -1094716342843794294L;
    protected ParameterList parameterList;
    private static final URLCodec URL_CODEC = new URLCodec("ISO-8859-1");
    private static final Pattern P_ENC = Pattern.compile("%\\s([0-9a-fA-F]{2})");

    protected ParameterizedHeader() {
    }

    @Override
    public int compareTo(ParameterizedHeader other) {
        if (this == other) {
            return 0;
        }
        if (this.parameterList == null) {
            if (other.parameterList != null) {
                return -1;
            }
            return 0;
        }
        if (other.parameterList == null) {
            return 1;
        }
        return this.parameterList.compareTo(other.parameterList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterList == null ? 0 : this.parameterList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedHeader)) {
            return false;
        }
        ParameterizedHeader other = (ParameterizedHeader)obj;
        return !(this.parameterList == null ? other.parameterList != null : !this.parameterList.equals(other.parameterList));
    }

    public void addParameter(String key, String value) {
        this.parameterList.addParameter(key, value);
    }

    public void setParameter(String key, String value) {
        this.parameterList.setParameter(key, value);
    }

    public void setParameterErrorAware(String key, String value) throws OXException {
        this.parameterList.setParameterErrorAware(key, value);
    }

    public String getParameter(String key) {
        String value = this.parameterList.getParameter(key);
        return null == value ? null : MimeMessageUtility.decodeMultiEncodedHeader(value);
    }

    public String removeParameter(String key) {
        String value = this.parameterList.removeParameter(key);
        return null == value ? null : MimeMessageUtility.decodeMultiEncodedHeader(value);
    }

    public boolean containsParameter(String key) {
        return this.parameterList.containsParameter(key);
    }

    public Iterator<String> getParameterNames() {
        return this.parameterList.getParameterNames();
    }

    public void clearParameters() {
        this.parameterList.clearParameters();
    }

    protected static final String prepareParameterizedHeader(String paramHdrArg) {
        int length;
        if (paramHdrArg == null) {
            return paramHdrArg;
        }
        String paramHdr = MimeMessageUtility.unfold(paramHdrArg.trim());
        if (paramHdr.indexOf("=?") >= 0) {
            paramHdr = MimeMessageUtility.decodeEnvelopeHeader(paramHdr).trim();
        }
        if ((length = paramHdr.length()) > 0) {
            int pos = length - 1;
            if (paramHdr.charAt(pos) == ';') {
                paramHdr = paramHdr.substring(0, pos);
            }
            pos = paramHdr.length() - 1;
            if (paramHdr.charAt(0) == '{' && paramHdr.charAt(pos) == '}') {
                paramHdr = paramHdr.substring(1, pos);
            } else if (paramHdr.charAt(0) == '[' && paramHdr.charAt(pos) == ']') {
                paramHdr = paramHdr.substring(1, pos);
            }
            pos = paramHdr.indexOf(59);
            if (pos > 0) {
                String value = paramHdr.substring(0, pos).trim();
                value = Strings.unparenthize((String)value);
                value = Strings.unquote((String)value);
                paramHdr = value + paramHdr.substring(pos);
            }
        }
        return paramHdr;
    }

    protected static String decodeUrl(String s) {
        try {
            return Strings.isEmpty((String)s) ? s : URL_CODEC.decode(P_ENC.matcher(s).replaceAll("%$1"));
        }
        catch (DecoderException e) {
            return s;
        }
    }
}

