/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataHandler;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.FileDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class VCardAttachMailDataHandler
implements DataHandler {
    private static final String[] ARGS = new String[0];
    private static final Class<?>[] TYPES = new Class[]{InputStream.class, byte[].class};
    private static final String FILE_PREFIX = "file://";

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public Object processData(Data<? extends Object> data, DataArguments dataArguments, Session session) throws OXException {
        Context ctx = ContextStorage.getStorageContext(session);
        UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx);
        try {
            DataProperties vcardProperties = data.getDataProperties();
            ManagedFile managedFile = VCardAttachMailDataHandler.getBytesFromVCard(data.getData());
            String fileName = vcardProperties.get("com.openexchange.conversion.name");
            fileName = fileName == null ? "vcard.vcf" : MimeUtility.encodeText((String)fileName, (String)"UTF-8", (String)"Q");
            managedFile.setFileName(fileName);
            ContentType ct = new ContentType(vcardProperties.get("com.openexchange.conversion.content-type"));
            ct.setCharsetParameter(vcardProperties.get("com.openexchange.conversion.charset"));
            managedFile.setContentType(ct.toString());
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            mimeMessage.setSubject(StringHelper.valueOf(UserStorage.getInstance().getUser(session.getUserId(), ctx).getLocale()).getString("[No Subject]"));
            if (usm.getSendAddr() != null) {
                mimeMessage.setFrom((Address)new QuotedInternetAddress(usm.getSendAddr(), false));
            }
            MimeMultipart mimeMultipart = new MimeMultipart("mixed");
            MimeBodyPart textPart = new MimeBodyPart();
            MessageUtility.setText("", "text/html; charset=UTF-8", "html", (Part)textPart);
            textPart.setHeader("MIME-Version", "1.0");
            textPart.setHeader("Content-Type", "text/html; charset=UTF-8");
            mimeMultipart.addBodyPart((BodyPart)textPart);
            MimeBodyPart vcardPart = new MimeBodyPart();
            vcardPart.setDataHandler(new javax.activation.DataHandler((DataSource)new FileDataSource(managedFile.getFile(), ct.toString())));
            if (fileName != null) {
                ContentDisposition cd = new ContentDisposition("attachment");
                cd.setFilenameParameter(fileName);
                vcardPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
            }
            vcardPart.setHeader("MIME-Version", "1.0");
            if (fileName != null && !ct.containsNameParameter()) {
                ct.setNameParameter(fileName);
            }
            vcardPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
            mimeMultipart.addBodyPart((BodyPart)vcardPart);
            MessageUtility.setContent((Multipart)mimeMultipart, (Part)mimeMessage);
            mimeMessage.saveChanges();
            mimeMessage.removeHeader("Message-ID");
            JSONObject mailObject = MessageWriter.writeMailMessage(0, MimeMessageConverter.convertMessage(mimeMessage), DisplayMode.MODIFYABLE, false, session, null);
            VCardAttachMailDataHandler.addFileInformation(mailObject, managedFile.getID());
            return mailObject;
        }
        catch (MessagingException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (JSONException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static void addFileInformation(JSONObject mailObject, String fileId) throws JSONException, OXException {
        if (!mailObject.has(MailJSONField.ATTACHMENTS.getKey()) || mailObject.isNull(MailJSONField.ATTACHMENTS.getKey())) {
            throw DataExceptionCodes.ERROR.create(new Object[]{new StringBuilder(64).append("Parsed JSON mail object does not contain field '").append(MailJSONField.ATTACHMENTS.getKey()).append('\'').toString()});
        }
        JSONArray attachmentArray = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
        int len = attachmentArray.length();
        if (len != 2) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Number of attachments in parsed JSON mail object is not equal to 2"});
        }
        JSONObject vcardAttachmentObject = attachmentArray.getJSONObject(1);
        vcardAttachmentObject.remove(MailListField.ID.getKey());
        vcardAttachmentObject.put(MailListField.ID.getKey(), (Object)new StringBuilder(FILE_PREFIX.length() + fileId.length()).append(FILE_PREFIX).append(fileId).toString());
    }

    private static ManagedFile getBytesFromVCard(Object vcard2) throws OXException {
        try {
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (null == management) {
                throw new IOException("Missing file management");
            }
            if (vcard2 instanceof InputStream) {
                return management.createManagedFile((InputStream)vcard2);
            }
            if (vcard2 instanceof byte[]) {
                return management.createManagedFile((byte[])vcard2);
            }
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{vcard2.getClass().getName()});
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

