/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.internal.DependenciesResolvedChecker;
import com.openexchange.groupware.update.internal.DependencyChecker;
import com.openexchange.groupware.update.internal.LowestVersionChecker;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UpdateTaskSorter {
    private static final DependencyChecker[] CHECKERS = new DependencyChecker[]{new DependenciesResolvedChecker(), new LowestVersionChecker()};

    public List<UpdateTask> sort(String[] executed, List<UpdateTask> toExecute) throws OXException {
        ArrayList<UpdateTask> retval = new ArrayList<UpdateTask>(toExecute.size());
        boolean found = true;
        while (!toExecute.isEmpty() && found) {
            found = false;
            Iterator<UpdateTask> iter = toExecute.iterator();
            while (iter.hasNext() && !found) {
                UpdateTask task = iter.next();
                UpdateTask[] retvalA = retval.toArray(new UpdateTask[retval.size()]);
                UpdateTask[] toExecuteA = toExecute.toArray(new UpdateTask[toExecute.size()]);
                for (int i = 0; i < CHECKERS.length && !found; ++i) {
                    found = CHECKERS[i].check(task, executed, retvalA, toExecuteA);
                }
                if (!found) continue;
                retval.add(task);
                iter.remove();
            }
        }
        if (!toExecute.isEmpty()) {
            throw UpdateExceptionCodes.UNRESOLVABLE_DEPENDENCIES.create(Strings.join((Object[])executed, (String)","), Strings.join(retval, (String)","), Strings.join(toExecute, (String)","));
        }
        return retval;
    }
}

