/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.TaskInfo;
import com.openexchange.groupware.update.internal.UpdateExecutor;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProcess
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProcess.class);
    private final int contextId;
    private final SchemaStore schemaStore = SchemaStore.getInstance();
    private final Queue<TaskInfo> failures;

    public UpdateProcess(int contextId) {
        this(contextId, false);
    }

    public UpdateProcess(int contextId, boolean traceFailures) {
        this.contextId = contextId;
        this.failures = traceFailures ? new ConcurrentLinkedQueue() : null;
    }

    public Queue<TaskInfo> getFailures() {
        return this.failures;
    }

    @Override
    public void run() {
        try {
            SchemaUpdateState state = this.schemaStore.getSchema(this.contextId);
            if (!UpdateTaskCollection.getInstance().needsUpdate(state)) {
                return;
            }
            new UpdateExecutor(state, this.contextId, null).execute(this.failures);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("", t);
        }
    }
}

