/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.SeparatedTasks;
import com.openexchange.groupware.update.TaskInfo;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.PerformParametersImpl;
import com.openexchange.groupware.update.internal.ProgressStatusImpl;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateExecutor.class);
    private static final SchemaStore store = SchemaStore.getInstance();
    private SchemaUpdateState state;
    private final int contextId;
    private final List<UpdateTask> tasks;
    private SeparatedTasks separatedTasks;

    public UpdateExecutor(SchemaUpdateState state, int contextId, List<UpdateTask> tasks2) {
        this.state = state;
        this.contextId = contextId;
        this.tasks = tasks2;
    }

    public void execute() throws OXException {
        this.execute(null);
    }

    public void execute(Queue<TaskInfo> failures) throws OXException {
        if (null != this.tasks) {
            this.separatedTasks = UpdateTaskCollection.getInstance().separateTasks(this.tasks);
            if (this.separatedTasks.getBlocking().size() > 0) {
                this.runUpdates(true, failures);
            }
            if (this.separatedTasks.getBackground().size() > 0) {
                this.runUpdates(false, failures);
            }
        } else {
            SeparatedTasks forCheck = UpdateTaskCollection.getInstance().getFilteredAndSeparatedTasks(this.state);
            if (forCheck.getBlocking().size() > 0) {
                this.runUpdates(true, failures);
            }
            if (forCheck.getBackground().size() > 0) {
                this.runUpdates(false, failures);
            }
        }
    }

    private void runUpdates(boolean blocking, Queue<TaskInfo> failures) throws OXException {
        LOG.info("Starting {} updates on schema {}", (Object)(blocking ? "blocking" : "background"), (Object)this.state.getSchema());
        try {
            this.lockSchema(blocking);
        }
        catch (OXException e) {
            if (e.getCode() != SchemaExceptionCodes.ALREADY_LOCKED.getNumber()) {
                try {
                    this.unlockSchema(blocking);
                }
                catch (OXException e1) {
                    LOG.error("", (Throwable)e1);
                }
            }
            throw e;
        }
        try {
            if (blocking) {
                this.removeContexts();
            }
            ArrayList<UpdateTask> scheduled = new ArrayList<UpdateTask>();
            if (null == this.separatedTasks) {
                this.state = store.getSchema(this.contextId);
                scheduled.addAll(UpdateTaskCollection.getInstance().getFilteredAndSortedUpdateTasks(this.state, blocking));
            } else {
                scheduled.addAll(blocking ? this.separatedTasks.getBlocking() : this.separatedTasks.getBackground());
            }
            int poolId = Database.resolvePool(this.contextId, true);
            for (UpdateTask task : scheduled) {
                String taskName = task.getClass().getSimpleName();
                boolean success = false;
                try {
                    LOG.info("Starting update task {} on schema {}.", (Object)taskName, (Object)this.state.getSchema());
                    if (task instanceof UpdateTaskV2) {
                        ProgressStatusImpl logger = new ProgressStatusImpl(taskName, this.state.getSchema());
                        PerformParametersImpl params = new PerformParametersImpl(this.state, this.contextId, logger);
                        ((UpdateTaskV2)task).perform(params);
                    } else {
                        task.perform(this.state, this.contextId);
                    }
                    success = true;
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                if (success) {
                    LOG.info("Update task {} on schema {} done.", (Object)taskName, (Object)this.state.getSchema());
                } else {
                    if (null != failures) {
                        failures.offer(new TaskInfo(taskName, this.state.getSchema()));
                    }
                    LOG.error("Update task {} on schema {} failed.", (Object)taskName, (Object)this.state.getSchema());
                }
                this.addExecutedTask(task.getClass().getName(), success, poolId, this.state.getSchema());
            }
            LOG.info("Finished {} updates on schema {}", (Object)(blocking ? "blocking" : "background"), (Object)this.state.getSchema());
        }
        catch (OXException e) {
            throw e;
        }
        catch (Throwable t) {
            throw UpdateExceptionCodes.UPDATE_FAILED.create(t, this.state.getSchema(), t.getMessage());
        }
        finally {
            this.unlockSchema(blocking);
            if (blocking) {
                this.removeContexts();
            }
        }
    }

    private final void lockSchema(boolean blocking) throws OXException {
        store.lockSchema(this.state, this.contextId, !blocking);
    }

    private final void unlockSchema(boolean blocking) throws OXException {
        store.unlockSchema(this.state, this.contextId, !blocking);
    }

    private final void addExecutedTask(String taskName, boolean success, int poolId, String schema) throws OXException {
        store.addExecutedTask(this.contextId, taskName, success, poolId, schema);
    }

    private final void removeContexts() throws OXException {
        int[] contextIds;
        ContextStorage contextStorage = ContextStorage.getInstance();
        for (int cid : contextIds = Database.getContextsInSameSchema(this.contextId)) {
            contextStorage.invalidateContext(cid);
        }
    }
}

