/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImportResult {
    private String objectId;
    private String folder;
    private OXException exception;
    private Date date;
    private int entryNumber;
    private String content;
    private final List<ConversionWarning> warnings = new ArrayList<ConversionWarning>();

    public ImportResult() {
    }

    public ImportResult(String objectId, String folder, Date date) {
        this(objectId, folder, date, null);
    }

    public ImportResult(String objectId, String folder, Date date, OXException exception) {
        this(objectId, folder, date, exception, -1, null);
    }

    public ImportResult(String objectId, String folder, Date date, OXException exception, int entryNumber, String content) {
        this.objectId = objectId;
        this.folder = folder;
        this.date = date;
        this.exception = exception;
        this.content = content;
        this.entryNumber = entryNumber;
    }

    public ImportResult(String objectId, String folder, long timestamp) {
        this(objectId, folder, new Date(timestamp));
    }

    public ImportResult(String objectId, String folder, long timestamp, OXException exception) {
        this(objectId, folder, new Date(timestamp), exception);
    }

    public boolean isCorrect() {
        return this.exception == null;
    }

    public boolean hasError() {
        return this.exception != null;
    }

    public OXException getException() {
        return this.exception;
    }

    public void setException(OXException exception) {
        this.exception = exception;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(int entryNumber) {
        this.entryNumber = entryNumber;
    }

    public List<ConversionWarning> getWarnings() {
        return this.warnings;
    }

    public void addWarnings(List<ConversionWarning> warningList) {
        this.warnings.addAll(warningList);
    }
}

